package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class EventSourceBuilder extends EventSourceFluent<EventSourceBuilder> implements VisitableBuilder<EventSource,EventSourceBuilder>{
  public EventSourceBuilder() {
    this(new EventSource());
  }
  
  public EventSourceBuilder(EventSourceFluent<?> fluent) {
    this(fluent, new EventSource());
  }
  
  public EventSourceBuilder(EventSourceFluent<?> fluent,EventSource instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public EventSourceBuilder(EventSource instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  EventSourceFluent<?> fluent;
  
  public EventSource build() {
    EventSource buildable = new EventSource(fluent.getComponent(),fluent.getHost());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}