package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class GroupVersionKindBuilder extends GroupVersionKindFluent<GroupVersionKindBuilder> implements VisitableBuilder<GroupVersionKind,GroupVersionKindBuilder>{
  public GroupVersionKindBuilder() {
    this(new GroupVersionKind());
  }
  
  public GroupVersionKindBuilder(GroupVersionKindFluent<?> fluent) {
    this(fluent, new GroupVersionKind());
  }
  
  public GroupVersionKindBuilder(GroupVersionKindFluent<?> fluent,GroupVersionKind instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public GroupVersionKindBuilder(GroupVersionKind instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  GroupVersionKindFluent<?> fluent;
  
  public GroupVersionKind build() {
    GroupVersionKind buildable = new GroupVersionKind(fluent.getGroup(),fluent.getKind(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}