package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class NodeSpecBuilder extends NodeSpecFluent<NodeSpecBuilder> implements VisitableBuilder<NodeSpec,NodeSpecBuilder>{
  public NodeSpecBuilder() {
    this(new NodeSpec());
  }
  
  public NodeSpecBuilder(NodeSpecFluent<?> fluent) {
    this(fluent, new NodeSpec());
  }
  
  public NodeSpecBuilder(NodeSpecFluent<?> fluent,NodeSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public NodeSpecBuilder(NodeSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  NodeSpecFluent<?> fluent;
  
  public NodeSpec build() {
    NodeSpec buildable = new NodeSpec(fluent.buildConfigSource(),fluent.getExternalID(),fluent.getPodCIDR(),fluent.getPodCIDRs(),fluent.getProviderID(),fluent.buildTaints(),fluent.getUnschedulable());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}