package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PodIPBuilder extends PodIPFluent<PodIPBuilder> implements VisitableBuilder<PodIP,PodIPBuilder>{
  public PodIPBuilder() {
    this(new PodIP());
  }
  
  public PodIPBuilder(PodIPFluent<?> fluent) {
    this(fluent, new PodIP());
  }
  
  public PodIPBuilder(PodIPFluent<?> fluent,PodIP instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PodIPBuilder(PodIP instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PodIPFluent<?> fluent;
  
  public PodIP build() {
    PodIP buildable = new PodIP(fluent.getIp());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}