package io.fabric8.kubernetes.api.model.discovery.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ForZoneBuilder extends ForZoneFluent<ForZoneBuilder> implements VisitableBuilder<ForZone,ForZoneBuilder>{
  public ForZoneBuilder() {
    this(new ForZone());
  }
  
  public ForZoneBuilder(ForZoneFluent<?> fluent) {
    this(fluent, new ForZone());
  }
  
  public ForZoneBuilder(ForZoneFluent<?> fluent,ForZone instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ForZoneBuilder(ForZone instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ForZoneFluent<?> fluent;
  
  public ForZone build() {
    ForZone buildable = new ForZone(fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}