/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.jsonschema2pojo;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JType;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jsonschema2pojo.Schema;
import org.jsonschema2pojo.rules.DefaultRule;
import org.jsonschema2pojo.rules.RuleFactory;

public class Fabric8DefaultRule
extends DefaultRule {
    private final RuleFactory ruleFactory;

    public Fabric8DefaultRule(RuleFactory ruleFactory) {
        super(ruleFactory);
        this.ruleFactory = ruleFactory;
    }

    public JFieldVar apply(String nodeName, JsonNode node, JsonNode parent, JFieldVar field, Schema currentSchema) {
        JType fieldType = field.type();
        String fieldTypeName = fieldType.fullName();
        if (this.ruleFactory.getGenerationConfig().isInitializeCollections() && fieldTypeName.startsWith(Map.class.getName()) && (node == null || node.asText() == null || node.asText().isEmpty())) {
            JClass keyGenericType = (JClass)((JClass)fieldType).getTypeParameters().get(0);
            JClass valueGenericType = (JClass)((JClass)fieldType).getTypeParameters().get(1);
            JClass mapImplClass = fieldType.owner().ref(LinkedHashMap.class);
            mapImplClass = mapImplClass.narrow(new JClass[]{keyGenericType, valueGenericType});
            field.annotate(JsonInclude.class).param("value", (Enum)JsonInclude.Include.NON_EMPTY);
            field.init((JExpression)JExpr._new((JClass)mapImplClass));
        }
        return super.apply(nodeName, node, parent, field, currentSchema);
    }
}

