package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class NetworkPolicyPortBuilder extends NetworkPolicyPortFluent<NetworkPolicyPortBuilder> implements VisitableBuilder<NetworkPolicyPort,NetworkPolicyPortBuilder>{
  public NetworkPolicyPortBuilder() {
    this(new NetworkPolicyPort());
  }
  
  public NetworkPolicyPortBuilder(NetworkPolicyPortFluent<?> fluent) {
    this(fluent, new NetworkPolicyPort());
  }
  
  public NetworkPolicyPortBuilder(NetworkPolicyPortFluent<?> fluent,NetworkPolicyPort instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public NetworkPolicyPortBuilder(NetworkPolicyPort instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  NetworkPolicyPortFluent<?> fluent;
  
  public NetworkPolicyPort build() {
    NetworkPolicyPort buildable = new NetworkPolicyPort(fluent.getEndPort(),fluent.buildPort(),fluent.getProtocol());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}