package io.fabric8.kubernetes.api.model.resource.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import io.fabric8.kubernetes.api.model.NodeSelector;
import java.lang.Boolean;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class AllocationResultFluent<A extends AllocationResultFluent<A>> extends BaseFluent<A>{
  public AllocationResultFluent() {
  }
  
  public AllocationResultFluent(AllocationResult instance) {
    this.copyInstance(instance);
  }
  private NodeSelector availableOnNodes;
  private ArrayList<ResourceHandleBuilder> resourceHandles = new ArrayList<ResourceHandleBuilder>();
  private Boolean shareable;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(AllocationResult instance) {
    instance = (instance != null ? instance : new AllocationResult());
    if (instance != null) {
          this.withAvailableOnNodes(instance.getAvailableOnNodes());
          this.withResourceHandles(instance.getResourceHandles());
          this.withShareable(instance.getShareable());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public NodeSelector getAvailableOnNodes() {
    return this.availableOnNodes;
  }
  
  public A withAvailableOnNodes(NodeSelector availableOnNodes) {
    this.availableOnNodes = availableOnNodes;
    return (A) this;
  }
  
  public boolean hasAvailableOnNodes() {
    return this.availableOnNodes != null;
  }
  
  public A addToResourceHandles(int index,ResourceHandle item) {
    if (this.resourceHandles == null) {this.resourceHandles = new ArrayList<ResourceHandleBuilder>();}
    ResourceHandleBuilder builder = new ResourceHandleBuilder(item);
    if (index < 0 || index >= resourceHandles.size()) { _visitables.get("resourceHandles").add(builder); resourceHandles.add(builder); } else { _visitables.get("resourceHandles").add(index, builder); resourceHandles.add(index, builder);}
    return (A)this;
  }
  
  public A setToResourceHandles(int index,ResourceHandle item) {
    if (this.resourceHandles == null) {this.resourceHandles = new ArrayList<ResourceHandleBuilder>();}
    ResourceHandleBuilder builder = new ResourceHandleBuilder(item);
    if (index < 0 || index >= resourceHandles.size()) { _visitables.get("resourceHandles").add(builder); resourceHandles.add(builder); } else { _visitables.get("resourceHandles").set(index, builder); resourceHandles.set(index, builder);}
    return (A)this;
  }
  
  public A addToResourceHandles(io.fabric8.kubernetes.api.model.resource.v1alpha2.ResourceHandle... items) {
    if (this.resourceHandles == null) {this.resourceHandles = new ArrayList<ResourceHandleBuilder>();}
    for (ResourceHandle item : items) {ResourceHandleBuilder builder = new ResourceHandleBuilder(item);_visitables.get("resourceHandles").add(builder);this.resourceHandles.add(builder);} return (A)this;
  }
  
  public A addAllToResourceHandles(Collection<ResourceHandle> items) {
    if (this.resourceHandles == null) {this.resourceHandles = new ArrayList<ResourceHandleBuilder>();}
    for (ResourceHandle item : items) {ResourceHandleBuilder builder = new ResourceHandleBuilder(item);_visitables.get("resourceHandles").add(builder);this.resourceHandles.add(builder);} return (A)this;
  }
  
  public A removeFromResourceHandles(io.fabric8.kubernetes.api.model.resource.v1alpha2.ResourceHandle... items) {
    if (this.resourceHandles == null) return (A)this;
    for (ResourceHandle item : items) {ResourceHandleBuilder builder = new ResourceHandleBuilder(item);_visitables.get("resourceHandles").remove(builder); this.resourceHandles.remove(builder);} return (A)this;
  }
  
  public A removeAllFromResourceHandles(Collection<ResourceHandle> items) {
    if (this.resourceHandles == null) return (A)this;
    for (ResourceHandle item : items) {ResourceHandleBuilder builder = new ResourceHandleBuilder(item);_visitables.get("resourceHandles").remove(builder); this.resourceHandles.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromResourceHandles(Predicate<ResourceHandleBuilder> predicate) {
    if (resourceHandles == null) return (A) this;
    final Iterator<ResourceHandleBuilder> each = resourceHandles.iterator();
    final List visitables = _visitables.get("resourceHandles");
    while (each.hasNext()) {
      ResourceHandleBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ResourceHandle> buildResourceHandles() {
    return this.resourceHandles != null ? build(resourceHandles) : null;
  }
  
  public ResourceHandle buildResourceHandle(int index) {
    return this.resourceHandles.get(index).build();
  }
  
  public ResourceHandle buildFirstResourceHandle() {
    return this.resourceHandles.get(0).build();
  }
  
  public ResourceHandle buildLastResourceHandle() {
    return this.resourceHandles.get(resourceHandles.size() - 1).build();
  }
  
  public ResourceHandle buildMatchingResourceHandle(Predicate<ResourceHandleBuilder> predicate) {
      for (ResourceHandleBuilder item : resourceHandles) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingResourceHandle(Predicate<ResourceHandleBuilder> predicate) {
      for (ResourceHandleBuilder item : resourceHandles) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withResourceHandles(List<ResourceHandle> resourceHandles) {
    if (this.resourceHandles != null) {
      this._visitables.get("resourceHandles").clear();
    }
    if (resourceHandles != null) {
        this.resourceHandles = new ArrayList();
        for (ResourceHandle item : resourceHandles) {
          this.addToResourceHandles(item);
        }
    } else {
      this.resourceHandles = null;
    }
    return (A) this;
  }
  
  public A withResourceHandles(io.fabric8.kubernetes.api.model.resource.v1alpha2.ResourceHandle... resourceHandles) {
    if (this.resourceHandles != null) {
        this.resourceHandles.clear();
        _visitables.remove("resourceHandles");
    }
    if (resourceHandles != null) {
      for (ResourceHandle item : resourceHandles) {
        this.addToResourceHandles(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasResourceHandles() {
    return this.resourceHandles != null && !this.resourceHandles.isEmpty();
  }
  
  public ResourceHandlesNested<A> addNewResourceHandle() {
    return new ResourceHandlesNested(-1, null);
  }
  
  public ResourceHandlesNested<A> addNewResourceHandleLike(ResourceHandle item) {
    return new ResourceHandlesNested(-1, item);
  }
  
  public ResourceHandlesNested<A> setNewResourceHandleLike(int index,ResourceHandle item) {
    return new ResourceHandlesNested(index, item);
  }
  
  public ResourceHandlesNested<A> editResourceHandle(int index) {
    if (resourceHandles.size() <= index) throw new RuntimeException("Can't edit resourceHandles. Index exceeds size.");
    return setNewResourceHandleLike(index, buildResourceHandle(index));
  }
  
  public ResourceHandlesNested<A> editFirstResourceHandle() {
    if (resourceHandles.size() == 0) throw new RuntimeException("Can't edit first resourceHandles. The list is empty.");
    return setNewResourceHandleLike(0, buildResourceHandle(0));
  }
  
  public ResourceHandlesNested<A> editLastResourceHandle() {
    int index = resourceHandles.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last resourceHandles. The list is empty.");
    return setNewResourceHandleLike(index, buildResourceHandle(index));
  }
  
  public ResourceHandlesNested<A> editMatchingResourceHandle(Predicate<ResourceHandleBuilder> predicate) {
    int index = -1;
    for (int i=0;i<resourceHandles.size();i++) { 
    if (predicate.test(resourceHandles.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching resourceHandles. No match found.");
    return setNewResourceHandleLike(index, buildResourceHandle(index));
  }
  
  public Boolean getShareable() {
    return this.shareable;
  }
  
  public A withShareable(Boolean shareable) {
    this.shareable = shareable;
    return (A) this;
  }
  
  public boolean hasShareable() {
    return this.shareable != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AllocationResultFluent that = (AllocationResultFluent) o;
    if (!java.util.Objects.equals(availableOnNodes, that.availableOnNodes)) return false;
    if (!java.util.Objects.equals(resourceHandles, that.resourceHandles)) return false;
    if (!java.util.Objects.equals(shareable, that.shareable)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(availableOnNodes,  resourceHandles,  shareable,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (availableOnNodes != null) { sb.append("availableOnNodes:"); sb.append(availableOnNodes + ","); }
    if (resourceHandles != null && !resourceHandles.isEmpty()) { sb.append("resourceHandles:"); sb.append(resourceHandles + ","); }
    if (shareable != null) { sb.append("shareable:"); sb.append(shareable + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withShareable() {
    return withShareable(true);
  }
  public class ResourceHandlesNested<N> extends ResourceHandleFluent<ResourceHandlesNested<N>> implements Nested<N>{
    ResourceHandlesNested(int index,ResourceHandle item) {
      this.index = index;
      this.builder = new ResourceHandleBuilder(this, item);
    }
    ResourceHandleBuilder builder;
    int index;
    
    public N and() {
      return (N) AllocationResultFluent.this.setToResourceHandles(index,builder.build());
    }
    
    public N endResourceHandle() {
      return and();
    }
    
  
  }

}