package io.fabric8.kubernetes.api.model.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface CSIDriverListFluent<A extends CSIDriverListFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public A addToItems(Integer index,CSIDriver item);
  public A setToItems(Integer index,CSIDriver item);
  public A addToItems(io.fabric8.kubernetes.api.model.storage.CSIDriver... items);
  public A addAllToItems(Collection<CSIDriver> items);
  public A removeFromItems(io.fabric8.kubernetes.api.model.storage.CSIDriver... items);
  public A removeAllFromItems(Collection<CSIDriver> items);
  public A removeMatchingFromItems(Predicate<CSIDriverBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<CSIDriver> getItems();
  public List<CSIDriver> buildItems();
  public CSIDriver buildItem(Integer index);
  public CSIDriver buildFirstItem();
  public CSIDriver buildLastItem();
  public CSIDriver buildMatchingItem(Predicate<CSIDriverBuilder> predicate);
  public Boolean hasMatchingItem(Predicate<CSIDriverBuilder> predicate);
  public A withItems(List<CSIDriver> items);
  public A withItems(io.fabric8.kubernetes.api.model.storage.CSIDriver... items);
  public Boolean hasItems();
  public CSIDriverListFluent.ItemsNested<A> addNewItem();
  public CSIDriverListFluent.ItemsNested<A> addNewItemLike(CSIDriver item);
  public CSIDriverListFluent.ItemsNested<A> setNewItemLike(Integer index,CSIDriver item);
  public CSIDriverListFluent.ItemsNested<A> editItem(Integer index);
  public CSIDriverListFluent.ItemsNested<A> editFirstItem();
  public CSIDriverListFluent.ItemsNested<A> editLastItem();
  public CSIDriverListFluent.ItemsNested<A> editMatchingItem(Predicate<CSIDriverBuilder> predicate);
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  public ListMeta getMetadata();
  public A withMetadata(ListMeta metadata);
  public Boolean hasMetadata();
  public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ItemsNested<N> extends Nested<N>,CSIDriverFluent<CSIDriverListFluent.ItemsNested<N>>{
    public N and();
    public N endItem();
    
  }
  
}