package io.fabric8.kubernetes.api.model.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CSINodeSpecBuilder extends CSINodeSpecFluentImpl<CSINodeSpecBuilder> implements VisitableBuilder<CSINodeSpec,CSINodeSpecBuilder>{
  public CSINodeSpecBuilder() {
    this(false);
  }
  public CSINodeSpecBuilder(Boolean validationEnabled) {
    this(new CSINodeSpec(), validationEnabled);
  }
  public CSINodeSpecBuilder(CSINodeSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public CSINodeSpecBuilder(CSINodeSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CSINodeSpec(), validationEnabled);
  }
  public CSINodeSpecBuilder(CSINodeSpecFluent<?> fluent,CSINodeSpec instance) {
    this(fluent, instance, false);
  }
  public CSINodeSpecBuilder(CSINodeSpecFluent<?> fluent,CSINodeSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDrivers(instance.getDrivers()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public CSINodeSpecBuilder(CSINodeSpec instance) {
    this(instance,false);
  }
  public CSINodeSpecBuilder(CSINodeSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withDrivers(instance.getDrivers()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  CSINodeSpecFluent<?> fluent;
  Boolean validationEnabled;
  public CSINodeSpec build() {
    CSINodeSpec buildable = new CSINodeSpec(fluent.getDrivers());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}