package io.fabric8.kubernetes.api.model.storage;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import io.fabric8.kubernetes.api.model.PersistentVolumeSpec;
import java.util.LinkedHashMap;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class VolumeAttachmentSourceFluentImpl<A extends VolumeAttachmentSourceFluent<A>> extends BaseFluent<A> implements VolumeAttachmentSourceFluent<A>{
  public VolumeAttachmentSourceFluentImpl() {
  }
  public VolumeAttachmentSourceFluentImpl(VolumeAttachmentSource instance) {
    this.withInlineVolumeSpec(instance.getInlineVolumeSpec()); 
    this.withPersistentVolumeName(instance.getPersistentVolumeName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private PersistentVolumeSpec inlineVolumeSpec;
  private String persistentVolumeName;
  private Map<String,Object> additionalProperties;
  public PersistentVolumeSpec getInlineVolumeSpec() {
    return this.inlineVolumeSpec;
  }
  public A withInlineVolumeSpec(PersistentVolumeSpec inlineVolumeSpec) {
    this.inlineVolumeSpec=inlineVolumeSpec; return (A) this;
  }
  public Boolean hasInlineVolumeSpec() {
    return this.inlineVolumeSpec != null;
  }
  public String getPersistentVolumeName() {
    return this.persistentVolumeName;
  }
  public A withPersistentVolumeName(String persistentVolumeName) {
    this.persistentVolumeName=persistentVolumeName; return (A) this;
  }
  public Boolean hasPersistentVolumeName() {
    return this.persistentVolumeName != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    VolumeAttachmentSourceFluentImpl that = (VolumeAttachmentSourceFluentImpl) o;
    if (inlineVolumeSpec != null ? !inlineVolumeSpec.equals(that.inlineVolumeSpec) :that.inlineVolumeSpec != null) return false;
    if (persistentVolumeName != null ? !persistentVolumeName.equals(that.persistentVolumeName) :that.persistentVolumeName != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(inlineVolumeSpec,  persistentVolumeName,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (inlineVolumeSpec != null) { sb.append("inlineVolumeSpec:"); sb.append(inlineVolumeSpec + ","); }
    if (persistentVolumeName != null) { sb.append("persistentVolumeName:"); sb.append(persistentVolumeName + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}