package io.fabric8.kubernetes.api.model.storage.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CSINodeDriverFluentImpl<A extends CSINodeDriverFluent<A>> extends BaseFluent<A> implements CSINodeDriverFluent<A>{
  public CSINodeDriverFluentImpl() {
  }
  public CSINodeDriverFluentImpl(CSINodeDriver instance) {
    this.withAllocatable(instance.getAllocatable()); 
    this.withName(instance.getName()); 
    this.withNodeID(instance.getNodeID()); 
    this.withTopologyKeys(instance.getTopologyKeys()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private VolumeNodeResourcesBuilder allocatable;
  private String name;
  private String nodeID;
  private List<String> topologyKeys = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildAllocatable instead.
   * @return The buildable object.
   */
  @Deprecated
  public VolumeNodeResources getAllocatable() {
    return this.allocatable!=null ?this.allocatable.build():null;
  }
  public VolumeNodeResources buildAllocatable() {
    return this.allocatable!=null ?this.allocatable.build():null;
  }
  public A withAllocatable(VolumeNodeResources allocatable) {
    _visitables.get("allocatable").remove(this.allocatable);
    if (allocatable!=null){ this.allocatable= new VolumeNodeResourcesBuilder(allocatable); _visitables.get("allocatable").add(this.allocatable);} else { this.allocatable = null; _visitables.get("allocatable").remove(this.allocatable); } return (A) this;
  }
  public Boolean hasAllocatable() {
    return this.allocatable != null;
  }
  public A withNewAllocatable(Integer count) {
    return (A)withAllocatable(new VolumeNodeResources(count));
  }
  public CSINodeDriverFluent.AllocatableNested<A> withNewAllocatable() {
    return new CSINodeDriverFluentImpl.AllocatableNestedImpl();
  }
  public CSINodeDriverFluent.AllocatableNested<A> withNewAllocatableLike(VolumeNodeResources item) {
    return new CSINodeDriverFluentImpl.AllocatableNestedImpl(item);
  }
  public CSINodeDriverFluent.AllocatableNested<A> editAllocatable() {
    return withNewAllocatableLike(getAllocatable());
  }
  public CSINodeDriverFluent.AllocatableNested<A> editOrNewAllocatable() {
    return withNewAllocatableLike(getAllocatable() != null ? getAllocatable(): new VolumeNodeResourcesBuilder().build());
  }
  public CSINodeDriverFluent.AllocatableNested<A> editOrNewAllocatableLike(VolumeNodeResources item) {
    return withNewAllocatableLike(getAllocatable() != null ? getAllocatable(): item);
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public Boolean hasName() {
    return this.name != null;
  }
  public String getNodeID() {
    return this.nodeID;
  }
  public A withNodeID(String nodeID) {
    this.nodeID=nodeID; return (A) this;
  }
  public Boolean hasNodeID() {
    return this.nodeID != null;
  }
  public A addToTopologyKeys(Integer index,String item) {
    if (this.topologyKeys == null) {this.topologyKeys = new ArrayList<String>();}
    this.topologyKeys.add(index, item);
    return (A)this;
  }
  public A setToTopologyKeys(Integer index,String item) {
    if (this.topologyKeys == null) {this.topologyKeys = new ArrayList<String>();}
    this.topologyKeys.set(index, item); return (A)this;
  }
  public A addToTopologyKeys(java.lang.String... items) {
    if (this.topologyKeys == null) {this.topologyKeys = new ArrayList<String>();}
    for (String item : items) {this.topologyKeys.add(item);} return (A)this;
  }
  public A addAllToTopologyKeys(Collection<String> items) {
    if (this.topologyKeys == null) {this.topologyKeys = new ArrayList<String>();}
    for (String item : items) {this.topologyKeys.add(item);} return (A)this;
  }
  public A removeFromTopologyKeys(java.lang.String... items) {
    for (String item : items) {if (this.topologyKeys!= null){ this.topologyKeys.remove(item);}} return (A)this;
  }
  public A removeAllFromTopologyKeys(Collection<String> items) {
    for (String item : items) {if (this.topologyKeys!= null){ this.topologyKeys.remove(item);}} return (A)this;
  }
  public List<String> getTopologyKeys() {
    return this.topologyKeys;
  }
  public String getTopologyKey(Integer index) {
    return this.topologyKeys.get(index);
  }
  public String getFirstTopologyKey() {
    return this.topologyKeys.get(0);
  }
  public String getLastTopologyKey() {
    return this.topologyKeys.get(topologyKeys.size() - 1);
  }
  public String getMatchingTopologyKey(Predicate<String> predicate) {
    for (String item: topologyKeys) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingTopologyKey(Predicate<String> predicate) {
    for (String item: topologyKeys) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTopologyKeys(List<String> topologyKeys) {
    if (topologyKeys != null) {this.topologyKeys = new ArrayList(); for (String item : topologyKeys){this.addToTopologyKeys(item);}} else { this.topologyKeys = null;} return (A) this;
  }
  public A withTopologyKeys(java.lang.String... topologyKeys) {
    if (this.topologyKeys != null) {this.topologyKeys.clear();}
    if (topologyKeys != null) {for (String item :topologyKeys){ this.addToTopologyKeys(item);}} return (A) this;
  }
  public Boolean hasTopologyKeys() {
    return topologyKeys != null && !topologyKeys.isEmpty();
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CSINodeDriverFluentImpl that = (CSINodeDriverFluentImpl) o;
    if (allocatable != null ? !allocatable.equals(that.allocatable) :that.allocatable != null) return false;
    if (name != null ? !name.equals(that.name) :that.name != null) return false;
    if (nodeID != null ? !nodeID.equals(that.nodeID) :that.nodeID != null) return false;
    if (topologyKeys != null ? !topologyKeys.equals(that.topologyKeys) :that.topologyKeys != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(allocatable,  name,  nodeID,  topologyKeys,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (allocatable != null) { sb.append("allocatable:"); sb.append(allocatable + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (nodeID != null) { sb.append("nodeID:"); sb.append(nodeID + ","); }
    if (topologyKeys != null && !topologyKeys.isEmpty()) { sb.append("topologyKeys:"); sb.append(topologyKeys + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class AllocatableNestedImpl<N> extends VolumeNodeResourcesFluentImpl<CSINodeDriverFluent.AllocatableNested<N>> implements CSINodeDriverFluent.AllocatableNested<N>,Nested<N>{
    AllocatableNestedImpl(VolumeNodeResources item) {
      this.builder = new VolumeNodeResourcesBuilder(this, item);
    }
    AllocatableNestedImpl() {
      this.builder = new VolumeNodeResourcesBuilder(this);
    }
    VolumeNodeResourcesBuilder builder;
    public N and() {
      return (N) CSINodeDriverFluentImpl.this.withAllocatable(builder.build());
    }
    public N endAllocatable() {
      return and();
    }
    
  }
  
}