/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorSpec;
import io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorSpecFluent;
import io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorSpecFluentImpl;
import java.util.Objects;

public class ServiceMonitorSpecBuilder
extends ServiceMonitorSpecFluentImpl<ServiceMonitorSpecBuilder>
implements VisitableBuilder<ServiceMonitorSpec, ServiceMonitorSpecBuilder> {
    ServiceMonitorSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceMonitorSpecBuilder() {
        this(false);
    }

    public ServiceMonitorSpecBuilder(Boolean validationEnabled) {
        this(new ServiceMonitorSpec(), validationEnabled);
    }

    public ServiceMonitorSpecBuilder(ServiceMonitorSpecFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ServiceMonitorSpecBuilder(ServiceMonitorSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ServiceMonitorSpec(), validationEnabled);
    }

    public ServiceMonitorSpecBuilder(ServiceMonitorSpecFluent<?> fluent, ServiceMonitorSpec instance) {
        this(fluent, instance, false);
    }

    public ServiceMonitorSpecBuilder(ServiceMonitorSpecFluent<?> fluent, ServiceMonitorSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withEndpoints(instance.getEndpoints());
        fluent.withJobLabel(instance.getJobLabel());
        fluent.withNamespaceSelector(instance.getNamespaceSelector());
        fluent.withPodTargetLabels(instance.getPodTargetLabels());
        fluent.withSampleLimit(instance.getSampleLimit());
        fluent.withSelector(instance.getSelector());
        fluent.withTargetLabels(instance.getTargetLabels());
        fluent.withTargetLimit(instance.getTargetLimit());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public ServiceMonitorSpecBuilder(ServiceMonitorSpec instance) {
        this(instance, (Boolean)false);
    }

    public ServiceMonitorSpecBuilder(ServiceMonitorSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withEndpoints(instance.getEndpoints());
        this.withJobLabel(instance.getJobLabel());
        this.withNamespaceSelector(instance.getNamespaceSelector());
        this.withPodTargetLabels(instance.getPodTargetLabels());
        this.withSampleLimit(instance.getSampleLimit());
        this.withSelector(instance.getSelector());
        this.withTargetLabels(instance.getTargetLabels());
        this.withTargetLimit(instance.getTargetLimit());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ServiceMonitorSpec build() {
        ServiceMonitorSpec buildable = new ServiceMonitorSpec(this.fluent.getEndpoints(), this.fluent.getJobLabel(), this.fluent.getNamespaceSelector(), this.fluent.getPodTargetLabels(), this.fluent.getSampleLimit(), this.fluent.getSelector(), this.fluent.getTargetLabels(), this.fluent.getTargetLimit());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceMonitorSpecBuilder that = (ServiceMonitorSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

