/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.mockwebserver.internal;

import io.fabric8.mockwebserver.MockServerException;
import io.fabric8.mockwebserver.dsl.HttpMethod;
import io.fabric8.mockwebserver.internal.SimpleRequest;
import io.fabric8.mockwebserver.internal.WebSocketMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okhttp3.mockwebserver.RecordedRequest;
import okio.ByteString;

public class WebSocketSession
extends WebSocketListener {
    private final List<WebSocketMessage> open;
    private final WebSocketMessage failure;
    private final Exception cause;
    private final Collection<WebSocket> activeSockets = ConcurrentHashMap.newKeySet();
    private final Collection<UUID> pendingMessages = ConcurrentHashMap.newKeySet();
    private final Map<Object, Queue<WebSocketMessage>> requestEvents = new HashMap<Object, Queue<WebSocketMessage>>();
    private final Map<Object, Queue<WebSocketMessage>> sentWebSocketMessagesRequestEvents = new HashMap<Object, Queue<WebSocketMessage>>();
    private final Map<SimpleRequest, Queue<WebSocketMessage>> httpRequestEvents = new HashMap<SimpleRequest, Queue<WebSocketMessage>>();
    private final List<WebSocketMessage> timedEvents = new ArrayList<WebSocketMessage>();
    private final ScheduledExecutorService executor;

    public WebSocketSession(List<WebSocketMessage> open, WebSocketMessage failure, Exception cause) {
        this.open = open;
        this.failure = failure;
        this.cause = cause;
        this.executor = Executors.newScheduledThreadPool(1);
    }

    public void onClosing(WebSocket webSocket, int code, String reason) {
        webSocket.close(code, reason);
    }

    public void onOpen(WebSocket webSocket, Response response) {
        this.activeSockets.add(webSocket);
        for (WebSocketMessage msg : this.open) {
            this.send(webSocket, msg);
        }
        for (WebSocketMessage msg : this.timedEvents) {
            this.send(webSocket, msg);
        }
        this.closeActiveSocketsIfApplicable();
    }

    public void onMessage(WebSocket webSocket, ByteString bytes) {
        this.onMessage(webSocket, bytes.utf8());
    }

    public void onMessage(WebSocket webSocket, String in) {
        Queue<WebSocketMessage> queue = this.requestEvents.get(in);
        this.send(webSocket, queue, in);
    }

    public void onClosed(WebSocket webSocket, int code, String reason) {
        this.activeSockets.remove(webSocket);
    }

    private void send(WebSocket ws, Queue<WebSocketMessage> queue, String in) {
        if (queue != null && !queue.isEmpty()) {
            WebSocketMessage msg = queue.peek();
            this.send(ws, msg);
            if (msg.isToBeRemoved()) {
                queue.remove();
            }
            this.checkIfShouldSendAgain(ws, msg);
        } else {
            ws.close(1002, "Unexpected message:" + in);
        }
    }

    private void checkIfShouldSendAgain(WebSocket ws, WebSocketMessage msg) {
        String text;
        String string = text = msg.isBinary() ? ByteString.of((byte[])msg.getBytes()).utf8() : msg.getBody();
        if (this.sentWebSocketMessagesRequestEvents.containsKey(text)) {
            Queue<WebSocketMessage> queue = this.sentWebSocketMessagesRequestEvents.get(text);
            this.send(ws, queue, text);
        }
    }

    public void dispatch(RecordedRequest request) {
        HttpMethod method = HttpMethod.valueOf(request.getMethod());
        String path = request.getPath();
        SimpleRequest key = new SimpleRequest(method, path);
        SimpleRequest keyForAnyMethod = new SimpleRequest(path);
        if (this.httpRequestEvents.containsKey(key)) {
            Queue<WebSocketMessage> queue = this.httpRequestEvents.get(key);
            this.activeSockets.forEach(ws -> this.send((WebSocket)ws, queue, "from http " + path));
        } else if (this.httpRequestEvents.containsKey(keyForAnyMethod)) {
            Queue<WebSocketMessage> queue = this.httpRequestEvents.get(keyForAnyMethod);
            this.activeSockets.forEach(ws -> this.send((WebSocket)ws, queue, "from http " + path));
        }
    }

    public List<WebSocketMessage> getOpen() {
        return this.open;
    }

    public WebSocketMessage getFailure() {
        return this.failure;
    }

    public Exception getCause() {
        return this.cause;
    }

    public Map<Object, Queue<WebSocketMessage>> getRequestEvents() {
        return this.requestEvents;
    }

    public List<WebSocketMessage> getTimedEvents() {
        return this.timedEvents;
    }

    public Map<Object, Queue<WebSocketMessage>> getSentWebSocketMessagesRequestEvents() {
        return this.sentWebSocketMessagesRequestEvents;
    }

    public Map<SimpleRequest, Queue<WebSocketMessage>> getHttpRequestEvents() {
        return this.httpRequestEvents;
    }

    private void send(WebSocket ws, WebSocketMessage message) {
        UUID id = UUID.randomUUID();
        this.pendingMessages.add(id);
        this.executor.schedule(() -> {
            if (ws != null) {
                if (message.isBinary()) {
                    ws.send(ByteString.of((byte[])message.getBytes()));
                } else {
                    ws.send(message.getBody());
                }
                this.pendingMessages.remove(id);
            }
            this.closeActiveSocketsIfApplicable();
        }, (long)message.getDelay(), TimeUnit.MILLISECONDS);
    }

    public void closeActiveSocketsIfApplicable() {
        if (this.pendingMessages.isEmpty() && this.requestEvents.isEmpty() && this.httpRequestEvents.isEmpty() && this.sentWebSocketMessagesRequestEvents.isEmpty()) {
            this.activeSockets.forEach(ws -> ws.close(1000, "Closing..."));
        }
    }

    public void shutdown() {
        try {
            this.executor.shutdown();
            if (!this.executor.awaitTermination(1L, TimeUnit.MINUTES)) {
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            throw MockServerException.launderThrowable(e);
        }
    }
}

