/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.internal;

import io.fabric8.kubernetes.client.utils.URLUtils;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.openshift.client.OpenShiftConfig;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class OpenShiftOAuthInterceptor
implements Interceptor {
    private static final String AUTHORIZATION = "Authorization";
    private static final String LOCATION = "Location";
    private static final String AUTHORIZE_PATH = "oauth/authorize?response_type=token&client_id=openshift-challenging-client";
    private static final String BEFORE_TOKEN = "access_token=";
    private static final String AFTER_TOKEN = "&expires";
    private final OkHttpClient client;
    private final OpenShiftConfig config;
    private final AtomicReference<String> oauthToken = new AtomicReference();

    public OpenShiftOAuthInterceptor(OkHttpClient client, OpenShiftConfig config) {
        this.client = client;
        this.config = config;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response;
        Request request = chain.request();
        Request.Builder builder = request.newBuilder();
        String token = null;
        if (Utils.isNotNullOrEmpty((String)this.oauthToken.get()) && Utils.isNullOrEmpty((String)request.header(AUTHORIZATION))) {
            token = this.oauthToken.get();
        } else if (Utils.isNotNullOrEmpty((String)this.config.getUsername()) && Utils.isNotNullOrEmpty((String)this.config.getPassword())) {
            token = this.acquireNewToken();
        } else if (Utils.isNotNullOrEmpty((String)this.config.getOauthToken())) {
            token = this.config.getOauthToken();
            this.oauthToken.set(token);
        }
        if (Utils.isNotNullOrEmpty((String)token) && Utils.isNullOrEmpty((String)request.header(AUTHORIZATION))) {
            this.setAuthHeader(builder, token);
        }
        if ((response = chain.proceed(request = builder.build())).code() != 401 && response.code() != 403) {
            return response;
        }
        if (Utils.isNotNullOrEmpty((String)this.config.getUsername()) && Utils.isNotNullOrEmpty((String)this.config.getPassword())) {
            token = this.acquireNewToken();
        } else if (Utils.isNotNullOrEmpty((String)this.config.getOauthToken())) {
            token = this.config.getOauthToken();
            this.oauthToken.set(token);
        }
        if (Utils.isNotNullOrEmpty((String)token)) {
            response.body().close();
            this.setAuthHeader(builder, token);
            request = builder.build();
            return chain.proceed(request);
        }
        return response;
    }

    private void setAuthHeader(Request.Builder builder, String token) {
        if (token != null) {
            builder.header(AUTHORIZATION, String.format("Bearer %s", token));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String acquireNewToken() throws IOException {
        OkHttpClient okHttpClient = this.client;
        synchronized (okHttpClient) {
            this.oauthToken.set(null);
            String token = this.authorize();
            if (token != null) {
                this.oauthToken.set(token);
            }
        }
        return this.oauthToken.get();
    }

    private String authorize() throws IOException {
        OkHttpClient.Builder builder = this.client.newBuilder();
        builder.interceptors().remove(this);
        OkHttpClient clone = builder.build();
        String credential = Credentials.basic((String)this.config.getUsername(), (String)new String(this.config.getPassword()));
        URL url = new URL(URLUtils.join((String[])new String[]{this.config.getMasterUrl(), AUTHORIZE_PATH}));
        Response response = clone.newCall(new Request.Builder().get().url(url).header(AUTHORIZATION, credential).build()).execute();
        response.body().close();
        response = response.priorResponse() != null ? response.priorResponse() : response;
        response = response.networkResponse() != null ? response.networkResponse() : response;
        String token = response.header(LOCATION);
        if (token == null || token.isEmpty()) {
            throw new IOException("Unexpected response(" + response.code() + " " + response.message() + "), to the authorization request. Missing header:[" + LOCATION + "]!");
        }
        token = token.substring(token.indexOf(BEFORE_TOKEN) + BEFORE_TOKEN.length());
        token = token.substring(0, token.indexOf(AFTER_TOKEN));
        return token;
    }
}

