/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.clusterautoscaling.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.clusterautoscaling.v1.ClusterAutoscalerSpec;
import io.fabric8.openshift.api.model.clusterautoscaling.v1.ClusterAutoscalerSpecFluent;
import io.fabric8.openshift.api.model.clusterautoscaling.v1.ResourceLimits;
import io.fabric8.openshift.api.model.clusterautoscaling.v1.ResourceLimitsBuilder;
import io.fabric8.openshift.api.model.clusterautoscaling.v1.ResourceLimitsFluentImpl;
import io.fabric8.openshift.api.model.clusterautoscaling.v1.ScaleDownConfig;
import io.fabric8.openshift.api.model.clusterautoscaling.v1.ScaleDownConfigBuilder;
import io.fabric8.openshift.api.model.clusterautoscaling.v1.ScaleDownConfigFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class ClusterAutoscalerSpecFluentImpl<A extends ClusterAutoscalerSpecFluent<A>>
extends BaseFluent<A>
implements ClusterAutoscalerSpecFluent<A> {
    private Boolean balanceSimilarNodeGroups;
    private Boolean ignoreDaemonsetsUtilization;
    private String maxNodeProvisionTime;
    private Integer maxPodGracePeriod;
    private Integer podPriorityThreshold;
    private ResourceLimitsBuilder resourceLimits;
    private ScaleDownConfigBuilder scaleDown;
    private Boolean skipNodesWithLocalStorage;
    private Map<String, Object> additionalProperties;

    public ClusterAutoscalerSpecFluentImpl() {
    }

    public ClusterAutoscalerSpecFluentImpl(ClusterAutoscalerSpec instance) {
        this.withBalanceSimilarNodeGroups(instance.getBalanceSimilarNodeGroups());
        this.withIgnoreDaemonsetsUtilization(instance.getIgnoreDaemonsetsUtilization());
        this.withMaxNodeProvisionTime(instance.getMaxNodeProvisionTime());
        this.withMaxPodGracePeriod(instance.getMaxPodGracePeriod());
        this.withPodPriorityThreshold(instance.getPodPriorityThreshold());
        this.withResourceLimits(instance.getResourceLimits());
        this.withScaleDown(instance.getScaleDown());
        this.withSkipNodesWithLocalStorage(instance.getSkipNodesWithLocalStorage());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public Boolean getBalanceSimilarNodeGroups() {
        return this.balanceSimilarNodeGroups;
    }

    @Override
    public A withBalanceSimilarNodeGroups(Boolean balanceSimilarNodeGroups) {
        this.balanceSimilarNodeGroups = balanceSimilarNodeGroups;
        return (A)this;
    }

    @Override
    public Boolean hasBalanceSimilarNodeGroups() {
        return this.balanceSimilarNodeGroups != null;
    }

    @Override
    public Boolean getIgnoreDaemonsetsUtilization() {
        return this.ignoreDaemonsetsUtilization;
    }

    @Override
    public A withIgnoreDaemonsetsUtilization(Boolean ignoreDaemonsetsUtilization) {
        this.ignoreDaemonsetsUtilization = ignoreDaemonsetsUtilization;
        return (A)this;
    }

    @Override
    public Boolean hasIgnoreDaemonsetsUtilization() {
        return this.ignoreDaemonsetsUtilization != null;
    }

    @Override
    public String getMaxNodeProvisionTime() {
        return this.maxNodeProvisionTime;
    }

    @Override
    public A withMaxNodeProvisionTime(String maxNodeProvisionTime) {
        this.maxNodeProvisionTime = maxNodeProvisionTime;
        return (A)this;
    }

    @Override
    public Boolean hasMaxNodeProvisionTime() {
        return this.maxNodeProvisionTime != null;
    }

    @Override
    @Deprecated
    public A withNewMaxNodeProvisionTime(String arg0) {
        return this.withMaxNodeProvisionTime(new String(arg0));
    }

    @Override
    public Integer getMaxPodGracePeriod() {
        return this.maxPodGracePeriod;
    }

    @Override
    public A withMaxPodGracePeriod(Integer maxPodGracePeriod) {
        this.maxPodGracePeriod = maxPodGracePeriod;
        return (A)this;
    }

    @Override
    public Boolean hasMaxPodGracePeriod() {
        return this.maxPodGracePeriod != null;
    }

    @Override
    public Integer getPodPriorityThreshold() {
        return this.podPriorityThreshold;
    }

    @Override
    public A withPodPriorityThreshold(Integer podPriorityThreshold) {
        this.podPriorityThreshold = podPriorityThreshold;
        return (A)this;
    }

    @Override
    public Boolean hasPodPriorityThreshold() {
        return this.podPriorityThreshold != null;
    }

    @Override
    @Deprecated
    public ResourceLimits getResourceLimits() {
        return this.resourceLimits != null ? this.resourceLimits.build() : null;
    }

    @Override
    public ResourceLimits buildResourceLimits() {
        return this.resourceLimits != null ? this.resourceLimits.build() : null;
    }

    @Override
    public A withResourceLimits(ResourceLimits resourceLimits) {
        this._visitables.get((Object)"resourceLimits").remove(this.resourceLimits);
        if (resourceLimits != null) {
            this.resourceLimits = new ResourceLimitsBuilder(resourceLimits);
            this._visitables.get((Object)"resourceLimits").add(this.resourceLimits);
        }
        return (A)this;
    }

    @Override
    public Boolean hasResourceLimits() {
        return this.resourceLimits != null;
    }

    @Override
    public ClusterAutoscalerSpecFluent.ResourceLimitsNested<A> withNewResourceLimits() {
        return new ResourceLimitsNestedImpl();
    }

    @Override
    public ClusterAutoscalerSpecFluent.ResourceLimitsNested<A> withNewResourceLimitsLike(ResourceLimits item) {
        return new ResourceLimitsNestedImpl(item);
    }

    @Override
    public ClusterAutoscalerSpecFluent.ResourceLimitsNested<A> editResourceLimits() {
        return this.withNewResourceLimitsLike(this.getResourceLimits());
    }

    @Override
    public ClusterAutoscalerSpecFluent.ResourceLimitsNested<A> editOrNewResourceLimits() {
        return this.withNewResourceLimitsLike(this.getResourceLimits() != null ? this.getResourceLimits() : new ResourceLimitsBuilder().build());
    }

    @Override
    public ClusterAutoscalerSpecFluent.ResourceLimitsNested<A> editOrNewResourceLimitsLike(ResourceLimits item) {
        return this.withNewResourceLimitsLike(this.getResourceLimits() != null ? this.getResourceLimits() : item);
    }

    @Override
    @Deprecated
    public ScaleDownConfig getScaleDown() {
        return this.scaleDown != null ? this.scaleDown.build() : null;
    }

    @Override
    public ScaleDownConfig buildScaleDown() {
        return this.scaleDown != null ? this.scaleDown.build() : null;
    }

    @Override
    public A withScaleDown(ScaleDownConfig scaleDown) {
        this._visitables.get((Object)"scaleDown").remove(this.scaleDown);
        if (scaleDown != null) {
            this.scaleDown = new ScaleDownConfigBuilder(scaleDown);
            this._visitables.get((Object)"scaleDown").add(this.scaleDown);
        }
        return (A)this;
    }

    @Override
    public Boolean hasScaleDown() {
        return this.scaleDown != null;
    }

    @Override
    public A withNewScaleDown(String delayAfterAdd, String delayAfterDelete, String delayAfterFailure, Boolean enabled, String unneededTime) {
        return this.withScaleDown(new ScaleDownConfig(delayAfterAdd, delayAfterDelete, delayAfterFailure, enabled, unneededTime));
    }

    @Override
    public ClusterAutoscalerSpecFluent.ScaleDownNested<A> withNewScaleDown() {
        return new ScaleDownNestedImpl();
    }

    @Override
    public ClusterAutoscalerSpecFluent.ScaleDownNested<A> withNewScaleDownLike(ScaleDownConfig item) {
        return new ScaleDownNestedImpl(item);
    }

    @Override
    public ClusterAutoscalerSpecFluent.ScaleDownNested<A> editScaleDown() {
        return this.withNewScaleDownLike(this.getScaleDown());
    }

    @Override
    public ClusterAutoscalerSpecFluent.ScaleDownNested<A> editOrNewScaleDown() {
        return this.withNewScaleDownLike(this.getScaleDown() != null ? this.getScaleDown() : new ScaleDownConfigBuilder().build());
    }

    @Override
    public ClusterAutoscalerSpecFluent.ScaleDownNested<A> editOrNewScaleDownLike(ScaleDownConfig item) {
        return this.withNewScaleDownLike(this.getScaleDown() != null ? this.getScaleDown() : item);
    }

    @Override
    public Boolean getSkipNodesWithLocalStorage() {
        return this.skipNodesWithLocalStorage;
    }

    @Override
    public A withSkipNodesWithLocalStorage(Boolean skipNodesWithLocalStorage) {
        this.skipNodesWithLocalStorage = skipNodesWithLocalStorage;
        return (A)this;
    }

    @Override
    public Boolean hasSkipNodesWithLocalStorage() {
        return this.skipNodesWithLocalStorage != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterAutoscalerSpecFluentImpl that = (ClusterAutoscalerSpecFluentImpl)o;
        if (this.balanceSimilarNodeGroups != null ? !this.balanceSimilarNodeGroups.equals(that.balanceSimilarNodeGroups) : that.balanceSimilarNodeGroups != null) {
            return false;
        }
        if (this.ignoreDaemonsetsUtilization != null ? !this.ignoreDaemonsetsUtilization.equals(that.ignoreDaemonsetsUtilization) : that.ignoreDaemonsetsUtilization != null) {
            return false;
        }
        if (this.maxNodeProvisionTime != null ? !this.maxNodeProvisionTime.equals(that.maxNodeProvisionTime) : that.maxNodeProvisionTime != null) {
            return false;
        }
        if (this.maxPodGracePeriod != null ? !this.maxPodGracePeriod.equals(that.maxPodGracePeriod) : that.maxPodGracePeriod != null) {
            return false;
        }
        if (this.podPriorityThreshold != null ? !this.podPriorityThreshold.equals(that.podPriorityThreshold) : that.podPriorityThreshold != null) {
            return false;
        }
        if (this.resourceLimits != null ? !this.resourceLimits.equals(that.resourceLimits) : that.resourceLimits != null) {
            return false;
        }
        if (this.scaleDown != null ? !this.scaleDown.equals(that.scaleDown) : that.scaleDown != null) {
            return false;
        }
        if (this.skipNodesWithLocalStorage != null ? !this.skipNodesWithLocalStorage.equals(that.skipNodesWithLocalStorage) : that.skipNodesWithLocalStorage != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.balanceSimilarNodeGroups, this.ignoreDaemonsetsUtilization, this.maxNodeProvisionTime, this.maxPodGracePeriod, this.podPriorityThreshold, this.resourceLimits, this.scaleDown, this.skipNodesWithLocalStorage, this.additionalProperties, super.hashCode());
    }

    public class ScaleDownNestedImpl<N>
    extends ScaleDownConfigFluentImpl<ClusterAutoscalerSpecFluent.ScaleDownNested<N>>
    implements ClusterAutoscalerSpecFluent.ScaleDownNested<N>,
    Nested<N> {
        ScaleDownConfigBuilder builder;

        ScaleDownNestedImpl(ScaleDownConfig item) {
            this.builder = new ScaleDownConfigBuilder(this, item);
        }

        ScaleDownNestedImpl() {
            this.builder = new ScaleDownConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterAutoscalerSpecFluentImpl.this.withScaleDown(this.builder.build());
        }

        @Override
        public N endScaleDown() {
            return this.and();
        }
    }

    public class ResourceLimitsNestedImpl<N>
    extends ResourceLimitsFluentImpl<ClusterAutoscalerSpecFluent.ResourceLimitsNested<N>>
    implements ClusterAutoscalerSpecFluent.ResourceLimitsNested<N>,
    Nested<N> {
        ResourceLimitsBuilder builder;

        ResourceLimitsNestedImpl(ResourceLimits item) {
            this.builder = new ResourceLimitsBuilder(this, item);
        }

        ResourceLimitsNestedImpl() {
            this.builder = new ResourceLimitsBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterAutoscalerSpecFluentImpl.this.withResourceLimits(this.builder.build());
        }

        @Override
        public N endResourceLimits() {
            return this.and();
        }
    }
}

