package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class AzurePlatformStatusBuilder extends AzurePlatformStatusFluent<AzurePlatformStatusBuilder> implements VisitableBuilder<AzurePlatformStatus,AzurePlatformStatusBuilder>{
  public AzurePlatformStatusBuilder() {
    this(new AzurePlatformStatus());
  }
  
  public AzurePlatformStatusBuilder(AzurePlatformStatusFluent<?> fluent) {
    this(fluent, new AzurePlatformStatus());
  }
  
  public AzurePlatformStatusBuilder(AzurePlatformStatusFluent<?> fluent,AzurePlatformStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public AzurePlatformStatusBuilder(AzurePlatformStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  AzurePlatformStatusFluent<?> fluent;
  
  public AzurePlatformStatus build() {
    AzurePlatformStatus buildable = new AzurePlatformStatus(fluent.getArmEndpoint(),fluent.getCloudName(),fluent.getNetworkResourceGroupName(),fluent.getResourceGroupName(),fluent.buildResourceTags());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}