package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ProxySpecBuilder extends ProxySpecFluent<ProxySpecBuilder> implements VisitableBuilder<ProxySpec,ProxySpecBuilder>{
  public ProxySpecBuilder() {
    this(new ProxySpec());
  }
  
  public ProxySpecBuilder(ProxySpecFluent<?> fluent) {
    this(fluent, new ProxySpec());
  }
  
  public ProxySpecBuilder(ProxySpecFluent<?> fluent,ProxySpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ProxySpecBuilder(ProxySpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ProxySpecFluent<?> fluent;
  
  public ProxySpec build() {
    ProxySpec buildable = new ProxySpec(fluent.getHttpProxy(),fluent.getHttpsProxy(),fluent.getNoProxy(),fluent.getReadinessEndpoints(),fluent.buildTrustedCA());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}