package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class APIServerStatusBuilder extends APIServerStatusFluent<APIServerStatusBuilder> implements VisitableBuilder<APIServerStatus,APIServerStatusBuilder>{
  public APIServerStatusBuilder() {
    this(new APIServerStatus());
  }
  
  public APIServerStatusBuilder(APIServerStatusFluent<?> fluent) {
    this(fluent, new APIServerStatus());
  }
  
  public APIServerStatusBuilder(APIServerStatusFluent<?> fluent,APIServerStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public APIServerStatusBuilder(APIServerStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  APIServerStatusFluent<?> fluent;
  
  public APIServerStatus build() {
    APIServerStatus buildable = new APIServerStatus();
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}