package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class AWSPrivateLinkConfigBuilder extends AWSPrivateLinkConfigFluent<AWSPrivateLinkConfigBuilder> implements VisitableBuilder<AWSPrivateLinkConfig,AWSPrivateLinkConfigBuilder>{
  public AWSPrivateLinkConfigBuilder() {
    this(new AWSPrivateLinkConfig());
  }
  
  public AWSPrivateLinkConfigBuilder(AWSPrivateLinkConfigFluent<?> fluent) {
    this(fluent, new AWSPrivateLinkConfig());
  }
  
  public AWSPrivateLinkConfigBuilder(AWSPrivateLinkConfigFluent<?> fluent,AWSPrivateLinkConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public AWSPrivateLinkConfigBuilder(AWSPrivateLinkConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  AWSPrivateLinkConfigFluent<?> fluent;
  
  public AWSPrivateLinkConfig build() {
    AWSPrivateLinkConfig buildable = new AWSPrivateLinkConfig(fluent.buildAssociatedVPCs(),fluent.buildCredentialsSecretRef(),fluent.getDnsRecordType(),fluent.buildEndpointVPCInventory());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}