package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ClusterStateStatusBuilder extends ClusterStateStatusFluent<ClusterStateStatusBuilder> implements VisitableBuilder<ClusterStateStatus,ClusterStateStatusBuilder>{
  public ClusterStateStatusBuilder() {
    this(new ClusterStateStatus());
  }
  
  public ClusterStateStatusBuilder(ClusterStateStatusFluent<?> fluent) {
    this(fluent, new ClusterStateStatus());
  }
  
  public ClusterStateStatusBuilder(ClusterStateStatusFluent<?> fluent,ClusterStateStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ClusterStateStatusBuilder(ClusterStateStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ClusterStateStatusFluent<?> fluent;
  
  public ClusterStateStatus build() {
    ClusterStateStatus buildable = new ClusterStateStatus(fluent.buildClusterOperators(),fluent.getLastUpdated());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}