package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ClusterDeploymentSpecBuilder extends ClusterDeploymentSpecFluent<ClusterDeploymentSpecBuilder> implements VisitableBuilder<ClusterDeploymentSpec,ClusterDeploymentSpecBuilder>{
  public ClusterDeploymentSpecBuilder() {
    this(new ClusterDeploymentSpec());
  }
  
  public ClusterDeploymentSpecBuilder(ClusterDeploymentSpecFluent<?> fluent) {
    this(fluent, new ClusterDeploymentSpec());
  }
  
  public ClusterDeploymentSpecBuilder(ClusterDeploymentSpecFluent<?> fluent,ClusterDeploymentSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ClusterDeploymentSpecBuilder(ClusterDeploymentSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ClusterDeploymentSpecFluent<?> fluent;
  
  public ClusterDeploymentSpec build() {
    ClusterDeploymentSpec buildable = new ClusterDeploymentSpec(fluent.getBaseDomain(),fluent.buildBoundServiceAccountSigningKeySecretRef(),fluent.buildCertificateBundles(),fluent.buildClusterInstallRef(),fluent.buildClusterMetadata(),fluent.getClusterName(),fluent.buildClusterPoolRef(),fluent.buildControlPlaneConfig(),fluent.getHibernateAfter(),fluent.buildIngress(),fluent.getInstallAttemptsLimit(),fluent.getInstalled(),fluent.getManageDNS(),fluent.buildPlatform(),fluent.getPowerState(),fluent.getPreserveOnDelete(),fluent.buildProvisioning(),fluent.buildPullSecretRef());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}