package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ClusterPoolConditionBuilder extends ClusterPoolConditionFluent<ClusterPoolConditionBuilder> implements VisitableBuilder<ClusterPoolCondition,ClusterPoolConditionBuilder>{
  public ClusterPoolConditionBuilder() {
    this(new ClusterPoolCondition());
  }
  
  public ClusterPoolConditionBuilder(ClusterPoolConditionFluent<?> fluent) {
    this(fluent, new ClusterPoolCondition());
  }
  
  public ClusterPoolConditionBuilder(ClusterPoolConditionFluent<?> fluent,ClusterPoolCondition instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ClusterPoolConditionBuilder(ClusterPoolCondition instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ClusterPoolConditionFluent<?> fluent;
  
  public ClusterPoolCondition build() {
    ClusterPoolCondition buildable = new ClusterPoolCondition(fluent.getLastProbeTime(),fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}