package io.fabric8.openshift.api.model.machine.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ControlPlaneMachineSetBuilder extends ControlPlaneMachineSetFluent<ControlPlaneMachineSetBuilder> implements VisitableBuilder<ControlPlaneMachineSet,ControlPlaneMachineSetBuilder>{
  public ControlPlaneMachineSetBuilder() {
    this(new ControlPlaneMachineSet());
  }
  
  public ControlPlaneMachineSetBuilder(ControlPlaneMachineSetFluent<?> fluent) {
    this(fluent, new ControlPlaneMachineSet());
  }
  
  public ControlPlaneMachineSetBuilder(ControlPlaneMachineSetFluent<?> fluent,ControlPlaneMachineSet instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ControlPlaneMachineSetBuilder(ControlPlaneMachineSet instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ControlPlaneMachineSetFluent<?> fluent;
  
  public ControlPlaneMachineSet build() {
    ControlPlaneMachineSet buildable = new ControlPlaneMachineSet(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}