package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.model.IntOrString;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.IntOrStringFluent;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class MachineConfigPoolSpecFluent<A extends MachineConfigPoolSpecFluent<A>> extends BaseFluent<A>{
  public MachineConfigPoolSpecFluent() {
  }
  
  public MachineConfigPoolSpecFluent(MachineConfigPoolSpec instance) {
    this.copyInstance(instance);
  }
  private MachineConfigPoolStatusConfigurationBuilder configuration;
  private LabelSelectorBuilder machineConfigSelector;
  private IntOrStringBuilder maxUnavailable;
  private LabelSelectorBuilder nodeSelector;
  private Boolean paused;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(MachineConfigPoolSpec instance) {
    instance = (instance != null ? instance : new MachineConfigPoolSpec());
    if (instance != null) {
          this.withConfiguration(instance.getConfiguration());
          this.withMachineConfigSelector(instance.getMachineConfigSelector());
          this.withMaxUnavailable(instance.getMaxUnavailable());
          this.withNodeSelector(instance.getNodeSelector());
          this.withPaused(instance.getPaused());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public MachineConfigPoolStatusConfiguration buildConfiguration() {
    return this.configuration != null ? this.configuration.build() : null;
  }
  
  public A withConfiguration(MachineConfigPoolStatusConfiguration configuration) {
    this._visitables.remove("configuration");
    if (configuration != null) {
        this.configuration = new MachineConfigPoolStatusConfigurationBuilder(configuration);
        this._visitables.get("configuration").add(this.configuration);
    } else {
        this.configuration = null;
        this._visitables.get("configuration").remove(this.configuration);
    }
    return (A) this;
  }
  
  public boolean hasConfiguration() {
    return this.configuration != null;
  }
  
  public ConfigurationNested<A> withNewConfiguration() {
    return new ConfigurationNested(null);
  }
  
  public ConfigurationNested<A> withNewConfigurationLike(MachineConfigPoolStatusConfiguration item) {
    return new ConfigurationNested(item);
  }
  
  public ConfigurationNested<A> editConfiguration() {
    return withNewConfigurationLike(java.util.Optional.ofNullable(buildConfiguration()).orElse(null));
  }
  
  public ConfigurationNested<A> editOrNewConfiguration() {
    return withNewConfigurationLike(java.util.Optional.ofNullable(buildConfiguration()).orElse(new MachineConfigPoolStatusConfigurationBuilder().build()));
  }
  
  public ConfigurationNested<A> editOrNewConfigurationLike(MachineConfigPoolStatusConfiguration item) {
    return withNewConfigurationLike(java.util.Optional.ofNullable(buildConfiguration()).orElse(item));
  }
  
  public LabelSelector buildMachineConfigSelector() {
    return this.machineConfigSelector != null ? this.machineConfigSelector.build() : null;
  }
  
  public A withMachineConfigSelector(LabelSelector machineConfigSelector) {
    this._visitables.remove("machineConfigSelector");
    if (machineConfigSelector != null) {
        this.machineConfigSelector = new LabelSelectorBuilder(machineConfigSelector);
        this._visitables.get("machineConfigSelector").add(this.machineConfigSelector);
    } else {
        this.machineConfigSelector = null;
        this._visitables.get("machineConfigSelector").remove(this.machineConfigSelector);
    }
    return (A) this;
  }
  
  public boolean hasMachineConfigSelector() {
    return this.machineConfigSelector != null;
  }
  
  public MachineConfigSelectorNested<A> withNewMachineConfigSelector() {
    return new MachineConfigSelectorNested(null);
  }
  
  public MachineConfigSelectorNested<A> withNewMachineConfigSelectorLike(LabelSelector item) {
    return new MachineConfigSelectorNested(item);
  }
  
  public MachineConfigSelectorNested<A> editMachineConfigSelector() {
    return withNewMachineConfigSelectorLike(java.util.Optional.ofNullable(buildMachineConfigSelector()).orElse(null));
  }
  
  public MachineConfigSelectorNested<A> editOrNewMachineConfigSelector() {
    return withNewMachineConfigSelectorLike(java.util.Optional.ofNullable(buildMachineConfigSelector()).orElse(new LabelSelectorBuilder().build()));
  }
  
  public MachineConfigSelectorNested<A> editOrNewMachineConfigSelectorLike(LabelSelector item) {
    return withNewMachineConfigSelectorLike(java.util.Optional.ofNullable(buildMachineConfigSelector()).orElse(item));
  }
  
  public IntOrString buildMaxUnavailable() {
    return this.maxUnavailable != null ? this.maxUnavailable.build() : null;
  }
  
  public A withMaxUnavailable(IntOrString maxUnavailable) {
    this._visitables.remove("maxUnavailable");
    if (maxUnavailable != null) {
        this.maxUnavailable = new IntOrStringBuilder(maxUnavailable);
        this._visitables.get("maxUnavailable").add(this.maxUnavailable);
    } else {
        this.maxUnavailable = null;
        this._visitables.get("maxUnavailable").remove(this.maxUnavailable);
    }
    return (A) this;
  }
  
  public boolean hasMaxUnavailable() {
    return this.maxUnavailable != null;
  }
  
  public A withNewMaxUnavailable(Object value) {
    return (A)withMaxUnavailable(new IntOrString(value));
  }
  
  public MaxUnavailableNested<A> withNewMaxUnavailable() {
    return new MaxUnavailableNested(null);
  }
  
  public MaxUnavailableNested<A> withNewMaxUnavailableLike(IntOrString item) {
    return new MaxUnavailableNested(item);
  }
  
  public MaxUnavailableNested<A> editMaxUnavailable() {
    return withNewMaxUnavailableLike(java.util.Optional.ofNullable(buildMaxUnavailable()).orElse(null));
  }
  
  public MaxUnavailableNested<A> editOrNewMaxUnavailable() {
    return withNewMaxUnavailableLike(java.util.Optional.ofNullable(buildMaxUnavailable()).orElse(new IntOrStringBuilder().build()));
  }
  
  public MaxUnavailableNested<A> editOrNewMaxUnavailableLike(IntOrString item) {
    return withNewMaxUnavailableLike(java.util.Optional.ofNullable(buildMaxUnavailable()).orElse(item));
  }
  
  public LabelSelector buildNodeSelector() {
    return this.nodeSelector != null ? this.nodeSelector.build() : null;
  }
  
  public A withNodeSelector(LabelSelector nodeSelector) {
    this._visitables.remove("nodeSelector");
    if (nodeSelector != null) {
        this.nodeSelector = new LabelSelectorBuilder(nodeSelector);
        this._visitables.get("nodeSelector").add(this.nodeSelector);
    } else {
        this.nodeSelector = null;
        this._visitables.get("nodeSelector").remove(this.nodeSelector);
    }
    return (A) this;
  }
  
  public boolean hasNodeSelector() {
    return this.nodeSelector != null;
  }
  
  public NodeSelectorNested<A> withNewNodeSelector() {
    return new NodeSelectorNested(null);
  }
  
  public NodeSelectorNested<A> withNewNodeSelectorLike(LabelSelector item) {
    return new NodeSelectorNested(item);
  }
  
  public NodeSelectorNested<A> editNodeSelector() {
    return withNewNodeSelectorLike(java.util.Optional.ofNullable(buildNodeSelector()).orElse(null));
  }
  
  public NodeSelectorNested<A> editOrNewNodeSelector() {
    return withNewNodeSelectorLike(java.util.Optional.ofNullable(buildNodeSelector()).orElse(new LabelSelectorBuilder().build()));
  }
  
  public NodeSelectorNested<A> editOrNewNodeSelectorLike(LabelSelector item) {
    return withNewNodeSelectorLike(java.util.Optional.ofNullable(buildNodeSelector()).orElse(item));
  }
  
  public Boolean getPaused() {
    return this.paused;
  }
  
  public A withPaused(Boolean paused) {
    this.paused = paused;
    return (A) this;
  }
  
  public boolean hasPaused() {
    return this.paused != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MachineConfigPoolSpecFluent that = (MachineConfigPoolSpecFluent) o;
    if (!java.util.Objects.equals(configuration, that.configuration)) return false;
    if (!java.util.Objects.equals(machineConfigSelector, that.machineConfigSelector)) return false;
    if (!java.util.Objects.equals(maxUnavailable, that.maxUnavailable)) return false;
    if (!java.util.Objects.equals(nodeSelector, that.nodeSelector)) return false;
    if (!java.util.Objects.equals(paused, that.paused)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(configuration,  machineConfigSelector,  maxUnavailable,  nodeSelector,  paused,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (configuration != null) { sb.append("configuration:"); sb.append(configuration + ","); }
    if (machineConfigSelector != null) { sb.append("machineConfigSelector:"); sb.append(machineConfigSelector + ","); }
    if (maxUnavailable != null) { sb.append("maxUnavailable:"); sb.append(maxUnavailable + ","); }
    if (nodeSelector != null) { sb.append("nodeSelector:"); sb.append(nodeSelector + ","); }
    if (paused != null) { sb.append("paused:"); sb.append(paused + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withPaused() {
    return withPaused(true);
  }
  public class ConfigurationNested<N> extends MachineConfigPoolStatusConfigurationFluent<ConfigurationNested<N>> implements Nested<N>{
    ConfigurationNested(MachineConfigPoolStatusConfiguration item) {
      this.builder = new MachineConfigPoolStatusConfigurationBuilder(this, item);
    }
    MachineConfigPoolStatusConfigurationBuilder builder;
    
    public N and() {
      return (N) MachineConfigPoolSpecFluent.this.withConfiguration(builder.build());
    }
    
    public N endConfiguration() {
      return and();
    }
    
  
  }
  public class MachineConfigSelectorNested<N> extends LabelSelectorFluent<MachineConfigSelectorNested<N>> implements Nested<N>{
    MachineConfigSelectorNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    
    public N and() {
      return (N) MachineConfigPoolSpecFluent.this.withMachineConfigSelector(builder.build());
    }
    
    public N endMachineConfigSelector() {
      return and();
    }
    
  
  }
  public class MaxUnavailableNested<N> extends IntOrStringFluent<MaxUnavailableNested<N>> implements Nested<N>{
    MaxUnavailableNested(IntOrString item) {
      this.builder = new IntOrStringBuilder(this, item);
    }
    IntOrStringBuilder builder;
    
    public N and() {
      return (N) MachineConfigPoolSpecFluent.this.withMaxUnavailable(builder.build());
    }
    
    public N endMaxUnavailable() {
      return and();
    }
    
  
  }
  public class NodeSelectorNested<N> extends LabelSelectorFluent<NodeSelectorNested<N>> implements Nested<N>{
    NodeSelectorNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    
    public N and() {
      return (N) MachineConfigPoolSpecFluent.this.withNodeSelector(builder.build());
    }
    
    public N endNodeSelector() {
      return and();
    }
    
  
  }

}