/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.miscellaneous.network.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.L4RedirectRule;
import io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.L4RedirectRuleBuilder;
import io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.L4RedirectRuleFluent;
import io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.RedirectConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class RedirectConfigFluent<A extends RedirectConfigFluent<A>>
extends BaseFluent<A> {
    private String fallbackIP;
    private ArrayList<L4RedirectRuleBuilder> redirectRules = new ArrayList();
    private Map<String, Object> additionalProperties;

    public RedirectConfigFluent() {
    }

    public RedirectConfigFluent(RedirectConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(RedirectConfig instance) {
        RedirectConfig redirectConfig = instance = instance != null ? instance : new RedirectConfig();
        if (instance != null) {
            this.withFallbackIP(instance.getFallbackIP());
            this.withRedirectRules(instance.getRedirectRules());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getFallbackIP() {
        return this.fallbackIP;
    }

    public A withFallbackIP(String fallbackIP) {
        this.fallbackIP = fallbackIP;
        return (A)((Object)this);
    }

    public boolean hasFallbackIP() {
        return this.fallbackIP != null;
    }

    public A addToRedirectRules(int index, L4RedirectRule item) {
        if (this.redirectRules == null) {
            this.redirectRules = new ArrayList();
        }
        L4RedirectRuleBuilder builder = new L4RedirectRuleBuilder(item);
        if (index < 0 || index >= this.redirectRules.size()) {
            this._visitables.get((Object)"redirectRules").add(builder);
            this.redirectRules.add(builder);
        } else {
            this._visitables.get((Object)"redirectRules").add(index, builder);
            this.redirectRules.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToRedirectRules(int index, L4RedirectRule item) {
        if (this.redirectRules == null) {
            this.redirectRules = new ArrayList();
        }
        L4RedirectRuleBuilder builder = new L4RedirectRuleBuilder(item);
        if (index < 0 || index >= this.redirectRules.size()) {
            this._visitables.get((Object)"redirectRules").add(builder);
            this.redirectRules.add(builder);
        } else {
            this._visitables.get((Object)"redirectRules").set(index, builder);
            this.redirectRules.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToRedirectRules(L4RedirectRule ... items) {
        if (this.redirectRules == null) {
            this.redirectRules = new ArrayList();
        }
        for (L4RedirectRule item : items) {
            L4RedirectRuleBuilder builder = new L4RedirectRuleBuilder(item);
            this._visitables.get((Object)"redirectRules").add(builder);
            this.redirectRules.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToRedirectRules(Collection<L4RedirectRule> items) {
        if (this.redirectRules == null) {
            this.redirectRules = new ArrayList();
        }
        for (L4RedirectRule item : items) {
            L4RedirectRuleBuilder builder = new L4RedirectRuleBuilder(item);
            this._visitables.get((Object)"redirectRules").add(builder);
            this.redirectRules.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromRedirectRules(L4RedirectRule ... items) {
        if (this.redirectRules == null) {
            return (A)((Object)this);
        }
        for (L4RedirectRule item : items) {
            L4RedirectRuleBuilder builder = new L4RedirectRuleBuilder(item);
            this._visitables.get((Object)"redirectRules").remove((Object)builder);
            this.redirectRules.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromRedirectRules(Collection<L4RedirectRule> items) {
        if (this.redirectRules == null) {
            return (A)((Object)this);
        }
        for (L4RedirectRule item : items) {
            L4RedirectRuleBuilder builder = new L4RedirectRuleBuilder(item);
            this._visitables.get((Object)"redirectRules").remove((Object)builder);
            this.redirectRules.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromRedirectRules(Predicate<L4RedirectRuleBuilder> predicate) {
        if (this.redirectRules == null) {
            return (A)((Object)this);
        }
        Iterator<L4RedirectRuleBuilder> each = this.redirectRules.iterator();
        List visitables = this._visitables.get((Object)"redirectRules");
        while (each.hasNext()) {
            L4RedirectRuleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<L4RedirectRule> buildRedirectRules() {
        return this.redirectRules != null ? RedirectConfigFluent.build(this.redirectRules) : null;
    }

    public L4RedirectRule buildRedirectRule(int index) {
        return this.redirectRules.get(index).build();
    }

    public L4RedirectRule buildFirstRedirectRule() {
        return this.redirectRules.get(0).build();
    }

    public L4RedirectRule buildLastRedirectRule() {
        return this.redirectRules.get(this.redirectRules.size() - 1).build();
    }

    public L4RedirectRule buildMatchingRedirectRule(Predicate<L4RedirectRuleBuilder> predicate) {
        for (L4RedirectRuleBuilder item : this.redirectRules) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingRedirectRule(Predicate<L4RedirectRuleBuilder> predicate) {
        for (L4RedirectRuleBuilder item : this.redirectRules) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRedirectRules(List<L4RedirectRule> redirectRules) {
        if (this.redirectRules != null) {
            this._visitables.get((Object)"redirectRules").clear();
        }
        if (redirectRules != null) {
            this.redirectRules = new ArrayList();
            for (L4RedirectRule item : redirectRules) {
                this.addToRedirectRules(item);
            }
        } else {
            this.redirectRules = null;
        }
        return (A)((Object)this);
    }

    public A withRedirectRules(L4RedirectRule ... redirectRules) {
        if (this.redirectRules != null) {
            this.redirectRules.clear();
            this._visitables.remove((Object)"redirectRules");
        }
        if (redirectRules != null) {
            for (L4RedirectRule item : redirectRules) {
                this.addToRedirectRules(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasRedirectRules() {
        return this.redirectRules != null && !this.redirectRules.isEmpty();
    }

    public A addNewRedirectRule(String destinationIP, Integer port, String protocol, Integer targetPort) {
        return this.addToRedirectRules(new L4RedirectRule(destinationIP, port, protocol, targetPort));
    }

    public RedirectRulesNested<A> addNewRedirectRule() {
        return new RedirectRulesNested(-1, null);
    }

    public RedirectRulesNested<A> addNewRedirectRuleLike(L4RedirectRule item) {
        return new RedirectRulesNested(-1, item);
    }

    public RedirectRulesNested<A> setNewRedirectRuleLike(int index, L4RedirectRule item) {
        return new RedirectRulesNested(index, item);
    }

    public RedirectRulesNested<A> editRedirectRule(int index) {
        if (this.redirectRules.size() <= index) {
            throw new RuntimeException("Can't edit redirectRules. Index exceeds size.");
        }
        return this.setNewRedirectRuleLike(index, this.buildRedirectRule(index));
    }

    public RedirectRulesNested<A> editFirstRedirectRule() {
        if (this.redirectRules.size() == 0) {
            throw new RuntimeException("Can't edit first redirectRules. The list is empty.");
        }
        return this.setNewRedirectRuleLike(0, this.buildRedirectRule(0));
    }

    public RedirectRulesNested<A> editLastRedirectRule() {
        int index = this.redirectRules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last redirectRules. The list is empty.");
        }
        return this.setNewRedirectRuleLike(index, this.buildRedirectRule(index));
    }

    public RedirectRulesNested<A> editMatchingRedirectRule(Predicate<L4RedirectRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.redirectRules.size(); ++i) {
            if (!predicate.test(this.redirectRules.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching redirectRules. No match found.");
        }
        return this.setNewRedirectRuleLike(index, this.buildRedirectRule(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RedirectConfigFluent that = (RedirectConfigFluent)((Object)o);
        if (!Objects.equals(this.fallbackIP, that.fallbackIP)) {
            return false;
        }
        if (!Objects.equals(this.redirectRules, that.redirectRules)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.fallbackIP, this.redirectRules, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.fallbackIP != null) {
            sb.append("fallbackIP:");
            sb.append(this.fallbackIP + ",");
        }
        if (this.redirectRules != null && !this.redirectRules.isEmpty()) {
            sb.append("redirectRules:");
            sb.append(this.redirectRules + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class RedirectRulesNested<N>
    extends L4RedirectRuleFluent<RedirectRulesNested<N>>
    implements Nested<N> {
        L4RedirectRuleBuilder builder;
        int index;

        RedirectRulesNested(int index, L4RedirectRule item) {
            this.index = index;
            this.builder = new L4RedirectRuleBuilder(this, item);
        }

        public N and() {
            return (N)RedirectConfigFluent.this.setToRedirectRules(this.index, this.builder.build());
        }

        public N endRedirectRule() {
            return this.and();
        }
    }
}

