/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.miscellaneous.cncf.cni.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.miscellaneous.cncf.cni.v1.DNS;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class DNSFluent<A extends DNSFluent<A>>
extends BaseFluent<A> {
    private String domain;
    private List<String> nameservers = new ArrayList<String>();
    private List<String> options = new ArrayList<String>();
    private List<String> search = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public DNSFluent() {
    }

    public DNSFluent(DNS instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(DNS instance) {
        DNS dNS = instance = instance != null ? instance : new DNS();
        if (instance != null) {
            this.withDomain(instance.getDomain());
            this.withNameservers(instance.getNameservers());
            this.withOptions(instance.getOptions());
            this.withSearch(instance.getSearch());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getDomain() {
        return this.domain;
    }

    public A withDomain(String domain) {
        this.domain = domain;
        return (A)((Object)this);
    }

    public boolean hasDomain() {
        return this.domain != null;
    }

    public A addToNameservers(int index, String item) {
        if (this.nameservers == null) {
            this.nameservers = new ArrayList<String>();
        }
        this.nameservers.add(index, item);
        return (A)((Object)this);
    }

    public A setToNameservers(int index, String item) {
        if (this.nameservers == null) {
            this.nameservers = new ArrayList<String>();
        }
        this.nameservers.set(index, item);
        return (A)((Object)this);
    }

    public A addToNameservers(String ... items) {
        if (this.nameservers == null) {
            this.nameservers = new ArrayList<String>();
        }
        for (String item : items) {
            this.nameservers.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToNameservers(Collection<String> items) {
        if (this.nameservers == null) {
            this.nameservers = new ArrayList<String>();
        }
        for (String item : items) {
            this.nameservers.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromNameservers(String ... items) {
        if (this.nameservers == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.nameservers.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromNameservers(Collection<String> items) {
        if (this.nameservers == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.nameservers.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getNameservers() {
        return this.nameservers;
    }

    public String getNameserver(int index) {
        return this.nameservers.get(index);
    }

    public String getFirstNameserver() {
        return this.nameservers.get(0);
    }

    public String getLastNameserver() {
        return this.nameservers.get(this.nameservers.size() - 1);
    }

    public String getMatchingNameserver(Predicate<String> predicate) {
        for (String item : this.nameservers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingNameserver(Predicate<String> predicate) {
        for (String item : this.nameservers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withNameservers(List<String> nameservers) {
        if (nameservers != null) {
            this.nameservers = new ArrayList<String>();
            for (String item : nameservers) {
                this.addToNameservers(item);
            }
        } else {
            this.nameservers = null;
        }
        return (A)((Object)this);
    }

    public A withNameservers(String ... nameservers) {
        if (this.nameservers != null) {
            this.nameservers.clear();
            this._visitables.remove((Object)"nameservers");
        }
        if (nameservers != null) {
            for (String item : nameservers) {
                this.addToNameservers(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasNameservers() {
        return this.nameservers != null && !this.nameservers.isEmpty();
    }

    public A addToOptions(int index, String item) {
        if (this.options == null) {
            this.options = new ArrayList<String>();
        }
        this.options.add(index, item);
        return (A)((Object)this);
    }

    public A setToOptions(int index, String item) {
        if (this.options == null) {
            this.options = new ArrayList<String>();
        }
        this.options.set(index, item);
        return (A)((Object)this);
    }

    public A addToOptions(String ... items) {
        if (this.options == null) {
            this.options = new ArrayList<String>();
        }
        for (String item : items) {
            this.options.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToOptions(Collection<String> items) {
        if (this.options == null) {
            this.options = new ArrayList<String>();
        }
        for (String item : items) {
            this.options.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromOptions(String ... items) {
        if (this.options == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.options.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromOptions(Collection<String> items) {
        if (this.options == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.options.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getOptions() {
        return this.options;
    }

    public String getOption(int index) {
        return this.options.get(index);
    }

    public String getFirstOption() {
        return this.options.get(0);
    }

    public String getLastOption() {
        return this.options.get(this.options.size() - 1);
    }

    public String getMatchingOption(Predicate<String> predicate) {
        for (String item : this.options) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingOption(Predicate<String> predicate) {
        for (String item : this.options) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withOptions(List<String> options) {
        if (options != null) {
            this.options = new ArrayList<String>();
            for (String item : options) {
                this.addToOptions(item);
            }
        } else {
            this.options = null;
        }
        return (A)((Object)this);
    }

    public A withOptions(String ... options) {
        if (this.options != null) {
            this.options.clear();
            this._visitables.remove((Object)"options");
        }
        if (options != null) {
            for (String item : options) {
                this.addToOptions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasOptions() {
        return this.options != null && !this.options.isEmpty();
    }

    public A addToSearch(int index, String item) {
        if (this.search == null) {
            this.search = new ArrayList<String>();
        }
        this.search.add(index, item);
        return (A)((Object)this);
    }

    public A setToSearch(int index, String item) {
        if (this.search == null) {
            this.search = new ArrayList<String>();
        }
        this.search.set(index, item);
        return (A)((Object)this);
    }

    public A addToSearch(String ... items) {
        if (this.search == null) {
            this.search = new ArrayList<String>();
        }
        for (String item : items) {
            this.search.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToSearch(Collection<String> items) {
        if (this.search == null) {
            this.search = new ArrayList<String>();
        }
        for (String item : items) {
            this.search.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromSearch(String ... items) {
        if (this.search == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.search.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromSearch(Collection<String> items) {
        if (this.search == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.search.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getSearch() {
        return this.search;
    }

    public String getSearch(int index) {
        return this.search.get(index);
    }

    public String getFirstSearch() {
        return this.search.get(0);
    }

    public String getLastSearch() {
        return this.search.get(this.search.size() - 1);
    }

    public String getMatchingSearch(Predicate<String> predicate) {
        for (String item : this.search) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingSearch(Predicate<String> predicate) {
        for (String item : this.search) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSearch(List<String> search) {
        if (search != null) {
            this.search = new ArrayList<String>();
            for (String item : search) {
                this.addToSearch(item);
            }
        } else {
            this.search = null;
        }
        return (A)((Object)this);
    }

    public A withSearch(String ... search) {
        if (this.search != null) {
            this.search.clear();
            this._visitables.remove((Object)"search");
        }
        if (search != null) {
            for (String item : search) {
                this.addToSearch(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasSearch() {
        return this.search != null && !this.search.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DNSFluent that = (DNSFluent)((Object)o);
        if (!Objects.equals(this.domain, that.domain)) {
            return false;
        }
        if (!Objects.equals(this.nameservers, that.nameservers)) {
            return false;
        }
        if (!Objects.equals(this.options, that.options)) {
            return false;
        }
        if (!Objects.equals(this.search, that.search)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.domain, this.nameservers, this.options, this.search, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.domain != null) {
            sb.append("domain:");
            sb.append(this.domain + ",");
        }
        if (this.nameservers != null && !this.nameservers.isEmpty()) {
            sb.append("nameservers:");
            sb.append(this.nameservers + ",");
        }
        if (this.options != null && !this.options.isEmpty()) {
            sb.append("options:");
            sb.append(this.options + ",");
        }
        if (this.search != null && !this.search.isEmpty()) {
            sb.append("search:");
            sb.append(this.search + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

