package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class QueueConfigBuilder extends QueueConfigFluent<QueueConfigBuilder> implements VisitableBuilder<QueueConfig,QueueConfigBuilder>{
  public QueueConfigBuilder() {
    this(new QueueConfig());
  }
  
  public QueueConfigBuilder(QueueConfigFluent<?> fluent) {
    this(fluent, new QueueConfig());
  }
  
  public QueueConfigBuilder(QueueConfigFluent<?> fluent,QueueConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public QueueConfigBuilder(QueueConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  QueueConfigFluent<?> fluent;
  
  public QueueConfig build() {
    QueueConfig buildable = new QueueConfig(fluent.getBatchSendDeadline(),fluent.getCapacity(),fluent.getMaxBackoff(),fluent.getMaxRetries(),fluent.getMaxSamplesPerSend(),fluent.getMaxShards(),fluent.getMinBackoff(),fluent.getMinShards(),fluent.getRetryOnRateLimit());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}