package io.fabric8.openshift.api.model.monitoring.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class WebTLSConfigFluent<A extends WebTLSConfigFluent<A>> extends BaseFluent<A>{
  public WebTLSConfigFluent() {
  }
  
  public WebTLSConfigFluent(WebTLSConfig instance) {
    this.copyInstance(instance);
  }
  private SecretOrConfigMapBuilder cert;
  private List<String> cipherSuites = new ArrayList<String>();
  private String clientAuthType;
  private SecretOrConfigMapBuilder clientCa;
  private List<String> curvePreferences = new ArrayList<String>();
  private SecretKeySelector keySecret;
  private String maxVersion;
  private String minVersion;
  private Boolean preferServerCipherSuites;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(WebTLSConfig instance) {
    instance = (instance != null ? instance : new WebTLSConfig());
    if (instance != null) {
          this.withCert(instance.getCert());
          this.withCipherSuites(instance.getCipherSuites());
          this.withClientAuthType(instance.getClientAuthType());
          this.withClientCa(instance.getClientCa());
          this.withCurvePreferences(instance.getCurvePreferences());
          this.withKeySecret(instance.getKeySecret());
          this.withMaxVersion(instance.getMaxVersion());
          this.withMinVersion(instance.getMinVersion());
          this.withPreferServerCipherSuites(instance.getPreferServerCipherSuites());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public SecretOrConfigMap buildCert() {
    return this.cert != null ? this.cert.build() : null;
  }
  
  public A withCert(SecretOrConfigMap cert) {
    this._visitables.remove("cert");
    if (cert != null) {
        this.cert = new SecretOrConfigMapBuilder(cert);
        this._visitables.get("cert").add(this.cert);
    } else {
        this.cert = null;
        this._visitables.get("cert").remove(this.cert);
    }
    return (A) this;
  }
  
  public boolean hasCert() {
    return this.cert != null;
  }
  
  public CertNested<A> withNewCert() {
    return new CertNested(null);
  }
  
  public CertNested<A> withNewCertLike(SecretOrConfigMap item) {
    return new CertNested(item);
  }
  
  public CertNested<A> editCert() {
    return withNewCertLike(java.util.Optional.ofNullable(buildCert()).orElse(null));
  }
  
  public CertNested<A> editOrNewCert() {
    return withNewCertLike(java.util.Optional.ofNullable(buildCert()).orElse(new SecretOrConfigMapBuilder().build()));
  }
  
  public CertNested<A> editOrNewCertLike(SecretOrConfigMap item) {
    return withNewCertLike(java.util.Optional.ofNullable(buildCert()).orElse(item));
  }
  
  public A addToCipherSuites(int index,String item) {
    if (this.cipherSuites == null) {this.cipherSuites = new ArrayList<String>();}
    this.cipherSuites.add(index, item);
    return (A)this;
  }
  
  public A setToCipherSuites(int index,String item) {
    if (this.cipherSuites == null) {this.cipherSuites = new ArrayList<String>();}
    this.cipherSuites.set(index, item); return (A)this;
  }
  
  public A addToCipherSuites(java.lang.String... items) {
    if (this.cipherSuites == null) {this.cipherSuites = new ArrayList<String>();}
    for (String item : items) {this.cipherSuites.add(item);} return (A)this;
  }
  
  public A addAllToCipherSuites(Collection<String> items) {
    if (this.cipherSuites == null) {this.cipherSuites = new ArrayList<String>();}
    for (String item : items) {this.cipherSuites.add(item);} return (A)this;
  }
  
  public A removeFromCipherSuites(java.lang.String... items) {
    if (this.cipherSuites == null) return (A)this;
    for (String item : items) { this.cipherSuites.remove(item);} return (A)this;
  }
  
  public A removeAllFromCipherSuites(Collection<String> items) {
    if (this.cipherSuites == null) return (A)this;
    for (String item : items) { this.cipherSuites.remove(item);} return (A)this;
  }
  
  public List<String> getCipherSuites() {
    return this.cipherSuites;
  }
  
  public String getCipherSuite(int index) {
    return this.cipherSuites.get(index);
  }
  
  public String getFirstCipherSuite() {
    return this.cipherSuites.get(0);
  }
  
  public String getLastCipherSuite() {
    return this.cipherSuites.get(cipherSuites.size() - 1);
  }
  
  public String getMatchingCipherSuite(Predicate<String> predicate) {
      for (String item : cipherSuites) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingCipherSuite(Predicate<String> predicate) {
      for (String item : cipherSuites) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withCipherSuites(List<String> cipherSuites) {
    if (cipherSuites != null) {
        this.cipherSuites = new ArrayList();
        for (String item : cipherSuites) {
          this.addToCipherSuites(item);
        }
    } else {
      this.cipherSuites = null;
    }
    return (A) this;
  }
  
  public A withCipherSuites(java.lang.String... cipherSuites) {
    if (this.cipherSuites != null) {
        this.cipherSuites.clear();
        _visitables.remove("cipherSuites");
    }
    if (cipherSuites != null) {
      for (String item : cipherSuites) {
        this.addToCipherSuites(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasCipherSuites() {
    return this.cipherSuites != null && !this.cipherSuites.isEmpty();
  }
  
  public String getClientAuthType() {
    return this.clientAuthType;
  }
  
  public A withClientAuthType(String clientAuthType) {
    this.clientAuthType = clientAuthType;
    return (A) this;
  }
  
  public boolean hasClientAuthType() {
    return this.clientAuthType != null;
  }
  
  public SecretOrConfigMap buildClientCa() {
    return this.clientCa != null ? this.clientCa.build() : null;
  }
  
  public A withClientCa(SecretOrConfigMap clientCa) {
    this._visitables.remove("clientCa");
    if (clientCa != null) {
        this.clientCa = new SecretOrConfigMapBuilder(clientCa);
        this._visitables.get("clientCa").add(this.clientCa);
    } else {
        this.clientCa = null;
        this._visitables.get("clientCa").remove(this.clientCa);
    }
    return (A) this;
  }
  
  public boolean hasClientCa() {
    return this.clientCa != null;
  }
  
  public ClientCaNested<A> withNewClientCa() {
    return new ClientCaNested(null);
  }
  
  public ClientCaNested<A> withNewClientCaLike(SecretOrConfigMap item) {
    return new ClientCaNested(item);
  }
  
  public ClientCaNested<A> editClientCa() {
    return withNewClientCaLike(java.util.Optional.ofNullable(buildClientCa()).orElse(null));
  }
  
  public ClientCaNested<A> editOrNewClientCa() {
    return withNewClientCaLike(java.util.Optional.ofNullable(buildClientCa()).orElse(new SecretOrConfigMapBuilder().build()));
  }
  
  public ClientCaNested<A> editOrNewClientCaLike(SecretOrConfigMap item) {
    return withNewClientCaLike(java.util.Optional.ofNullable(buildClientCa()).orElse(item));
  }
  
  public A addToCurvePreferences(int index,String item) {
    if (this.curvePreferences == null) {this.curvePreferences = new ArrayList<String>();}
    this.curvePreferences.add(index, item);
    return (A)this;
  }
  
  public A setToCurvePreferences(int index,String item) {
    if (this.curvePreferences == null) {this.curvePreferences = new ArrayList<String>();}
    this.curvePreferences.set(index, item); return (A)this;
  }
  
  public A addToCurvePreferences(java.lang.String... items) {
    if (this.curvePreferences == null) {this.curvePreferences = new ArrayList<String>();}
    for (String item : items) {this.curvePreferences.add(item);} return (A)this;
  }
  
  public A addAllToCurvePreferences(Collection<String> items) {
    if (this.curvePreferences == null) {this.curvePreferences = new ArrayList<String>();}
    for (String item : items) {this.curvePreferences.add(item);} return (A)this;
  }
  
  public A removeFromCurvePreferences(java.lang.String... items) {
    if (this.curvePreferences == null) return (A)this;
    for (String item : items) { this.curvePreferences.remove(item);} return (A)this;
  }
  
  public A removeAllFromCurvePreferences(Collection<String> items) {
    if (this.curvePreferences == null) return (A)this;
    for (String item : items) { this.curvePreferences.remove(item);} return (A)this;
  }
  
  public List<String> getCurvePreferences() {
    return this.curvePreferences;
  }
  
  public String getCurvePreference(int index) {
    return this.curvePreferences.get(index);
  }
  
  public String getFirstCurvePreference() {
    return this.curvePreferences.get(0);
  }
  
  public String getLastCurvePreference() {
    return this.curvePreferences.get(curvePreferences.size() - 1);
  }
  
  public String getMatchingCurvePreference(Predicate<String> predicate) {
      for (String item : curvePreferences) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingCurvePreference(Predicate<String> predicate) {
      for (String item : curvePreferences) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withCurvePreferences(List<String> curvePreferences) {
    if (curvePreferences != null) {
        this.curvePreferences = new ArrayList();
        for (String item : curvePreferences) {
          this.addToCurvePreferences(item);
        }
    } else {
      this.curvePreferences = null;
    }
    return (A) this;
  }
  
  public A withCurvePreferences(java.lang.String... curvePreferences) {
    if (this.curvePreferences != null) {
        this.curvePreferences.clear();
        _visitables.remove("curvePreferences");
    }
    if (curvePreferences != null) {
      for (String item : curvePreferences) {
        this.addToCurvePreferences(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasCurvePreferences() {
    return this.curvePreferences != null && !this.curvePreferences.isEmpty();
  }
  
  public SecretKeySelector getKeySecret() {
    return this.keySecret;
  }
  
  public A withKeySecret(SecretKeySelector keySecret) {
    this.keySecret = keySecret;
    return (A) this;
  }
  
  public boolean hasKeySecret() {
    return this.keySecret != null;
  }
  
  public A withNewKeySecret(String key,String name,Boolean optional) {
    return (A)withKeySecret(new SecretKeySelector(key, name, optional));
  }
  
  public String getMaxVersion() {
    return this.maxVersion;
  }
  
  public A withMaxVersion(String maxVersion) {
    this.maxVersion = maxVersion;
    return (A) this;
  }
  
  public boolean hasMaxVersion() {
    return this.maxVersion != null;
  }
  
  public String getMinVersion() {
    return this.minVersion;
  }
  
  public A withMinVersion(String minVersion) {
    this.minVersion = minVersion;
    return (A) this;
  }
  
  public boolean hasMinVersion() {
    return this.minVersion != null;
  }
  
  public Boolean getPreferServerCipherSuites() {
    return this.preferServerCipherSuites;
  }
  
  public A withPreferServerCipherSuites(Boolean preferServerCipherSuites) {
    this.preferServerCipherSuites = preferServerCipherSuites;
    return (A) this;
  }
  
  public boolean hasPreferServerCipherSuites() {
    return this.preferServerCipherSuites != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    WebTLSConfigFluent that = (WebTLSConfigFluent) o;
    if (!java.util.Objects.equals(cert, that.cert)) return false;
    if (!java.util.Objects.equals(cipherSuites, that.cipherSuites)) return false;
    if (!java.util.Objects.equals(clientAuthType, that.clientAuthType)) return false;
    if (!java.util.Objects.equals(clientCa, that.clientCa)) return false;
    if (!java.util.Objects.equals(curvePreferences, that.curvePreferences)) return false;
    if (!java.util.Objects.equals(keySecret, that.keySecret)) return false;
    if (!java.util.Objects.equals(maxVersion, that.maxVersion)) return false;
    if (!java.util.Objects.equals(minVersion, that.minVersion)) return false;
    if (!java.util.Objects.equals(preferServerCipherSuites, that.preferServerCipherSuites)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(cert,  cipherSuites,  clientAuthType,  clientCa,  curvePreferences,  keySecret,  maxVersion,  minVersion,  preferServerCipherSuites,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (cert != null) { sb.append("cert:"); sb.append(cert + ","); }
    if (cipherSuites != null && !cipherSuites.isEmpty()) { sb.append("cipherSuites:"); sb.append(cipherSuites + ","); }
    if (clientAuthType != null) { sb.append("clientAuthType:"); sb.append(clientAuthType + ","); }
    if (clientCa != null) { sb.append("clientCa:"); sb.append(clientCa + ","); }
    if (curvePreferences != null && !curvePreferences.isEmpty()) { sb.append("curvePreferences:"); sb.append(curvePreferences + ","); }
    if (keySecret != null) { sb.append("keySecret:"); sb.append(keySecret + ","); }
    if (maxVersion != null) { sb.append("maxVersion:"); sb.append(maxVersion + ","); }
    if (minVersion != null) { sb.append("minVersion:"); sb.append(minVersion + ","); }
    if (preferServerCipherSuites != null) { sb.append("preferServerCipherSuites:"); sb.append(preferServerCipherSuites + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withPreferServerCipherSuites() {
    return withPreferServerCipherSuites(true);
  }
  public class CertNested<N> extends SecretOrConfigMapFluent<CertNested<N>> implements Nested<N>{
    CertNested(SecretOrConfigMap item) {
      this.builder = new SecretOrConfigMapBuilder(this, item);
    }
    SecretOrConfigMapBuilder builder;
    
    public N and() {
      return (N) WebTLSConfigFluent.this.withCert(builder.build());
    }
    
    public N endCert() {
      return and();
    }
    
  
  }
  public class ClientCaNested<N> extends SecretOrConfigMapFluent<ClientCaNested<N>> implements Nested<N>{
    ClientCaNested(SecretOrConfigMap item) {
      this.builder = new SecretOrConfigMapBuilder(this, item);
    }
    SecretOrConfigMapBuilder builder;
    
    public N and() {
      return (N) WebTLSConfigFluent.this.withClientCa(builder.build());
    }
    
    public N endClientCa() {
      return and();
    }
    
  
  }

}