/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry;
import io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder;
import io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryFluent;
import io.fabric8.openshift.api.model.operator.v1.HybridOverlayConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class HybridOverlayConfigFluent<A extends HybridOverlayConfigFluent<A>>
extends BaseFluent<A> {
    private ArrayList<ClusterNetworkEntryBuilder> hybridClusterNetwork = new ArrayList();
    private Integer hybridOverlayVXLANPort;
    private Map<String, Object> additionalProperties;

    public HybridOverlayConfigFluent() {
    }

    public HybridOverlayConfigFluent(HybridOverlayConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(HybridOverlayConfig instance) {
        HybridOverlayConfig hybridOverlayConfig = instance = instance != null ? instance : new HybridOverlayConfig();
        if (instance != null) {
            this.withHybridClusterNetwork(instance.getHybridClusterNetwork());
            this.withHybridOverlayVXLANPort(instance.getHybridOverlayVXLANPort());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToHybridClusterNetwork(int index, ClusterNetworkEntry item) {
        if (this.hybridClusterNetwork == null) {
            this.hybridClusterNetwork = new ArrayList();
        }
        ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
        if (index < 0 || index >= this.hybridClusterNetwork.size()) {
            this._visitables.get((Object)"hybridClusterNetwork").add(builder);
            this.hybridClusterNetwork.add(builder);
        } else {
            this._visitables.get((Object)"hybridClusterNetwork").add(index, builder);
            this.hybridClusterNetwork.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToHybridClusterNetwork(int index, ClusterNetworkEntry item) {
        if (this.hybridClusterNetwork == null) {
            this.hybridClusterNetwork = new ArrayList();
        }
        ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
        if (index < 0 || index >= this.hybridClusterNetwork.size()) {
            this._visitables.get((Object)"hybridClusterNetwork").add(builder);
            this.hybridClusterNetwork.add(builder);
        } else {
            this._visitables.get((Object)"hybridClusterNetwork").set(index, builder);
            this.hybridClusterNetwork.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToHybridClusterNetwork(ClusterNetworkEntry ... items) {
        if (this.hybridClusterNetwork == null) {
            this.hybridClusterNetwork = new ArrayList();
        }
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get((Object)"hybridClusterNetwork").add(builder);
            this.hybridClusterNetwork.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToHybridClusterNetwork(Collection<ClusterNetworkEntry> items) {
        if (this.hybridClusterNetwork == null) {
            this.hybridClusterNetwork = new ArrayList();
        }
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get((Object)"hybridClusterNetwork").add(builder);
            this.hybridClusterNetwork.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromHybridClusterNetwork(ClusterNetworkEntry ... items) {
        if (this.hybridClusterNetwork == null) {
            return (A)((Object)this);
        }
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get((Object)"hybridClusterNetwork").remove((Object)builder);
            this.hybridClusterNetwork.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromHybridClusterNetwork(Collection<ClusterNetworkEntry> items) {
        if (this.hybridClusterNetwork == null) {
            return (A)((Object)this);
        }
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get((Object)"hybridClusterNetwork").remove((Object)builder);
            this.hybridClusterNetwork.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromHybridClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        if (this.hybridClusterNetwork == null) {
            return (A)((Object)this);
        }
        Iterator<ClusterNetworkEntryBuilder> each = this.hybridClusterNetwork.iterator();
        List visitables = this._visitables.get((Object)"hybridClusterNetwork");
        while (each.hasNext()) {
            ClusterNetworkEntryBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ClusterNetworkEntry> buildHybridClusterNetwork() {
        return this.hybridClusterNetwork != null ? HybridOverlayConfigFluent.build(this.hybridClusterNetwork) : null;
    }

    public ClusterNetworkEntry buildHybridClusterNetwork(int index) {
        return this.hybridClusterNetwork.get(index).build();
    }

    public ClusterNetworkEntry buildFirstHybridClusterNetwork() {
        return this.hybridClusterNetwork.get(0).build();
    }

    public ClusterNetworkEntry buildLastHybridClusterNetwork() {
        return this.hybridClusterNetwork.get(this.hybridClusterNetwork.size() - 1).build();
    }

    public ClusterNetworkEntry buildMatchingHybridClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        for (ClusterNetworkEntryBuilder item : this.hybridClusterNetwork) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingHybridClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        for (ClusterNetworkEntryBuilder item : this.hybridClusterNetwork) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withHybridClusterNetwork(List<ClusterNetworkEntry> hybridClusterNetwork) {
        if (this.hybridClusterNetwork != null) {
            this._visitables.get((Object)"hybridClusterNetwork").clear();
        }
        if (hybridClusterNetwork != null) {
            this.hybridClusterNetwork = new ArrayList();
            for (ClusterNetworkEntry item : hybridClusterNetwork) {
                this.addToHybridClusterNetwork(item);
            }
        } else {
            this.hybridClusterNetwork = null;
        }
        return (A)((Object)this);
    }

    public A withHybridClusterNetwork(ClusterNetworkEntry ... hybridClusterNetwork) {
        if (this.hybridClusterNetwork != null) {
            this.hybridClusterNetwork.clear();
            this._visitables.remove((Object)"hybridClusterNetwork");
        }
        if (hybridClusterNetwork != null) {
            for (ClusterNetworkEntry item : hybridClusterNetwork) {
                this.addToHybridClusterNetwork(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasHybridClusterNetwork() {
        return this.hybridClusterNetwork != null && !this.hybridClusterNetwork.isEmpty();
    }

    public A addNewHybridClusterNetwork(String cidr, Integer hostPrefix) {
        return this.addToHybridClusterNetwork(new ClusterNetworkEntry(cidr, hostPrefix));
    }

    public HybridClusterNetworkNested<A> addNewHybridClusterNetwork() {
        return new HybridClusterNetworkNested(-1, null);
    }

    public HybridClusterNetworkNested<A> addNewHybridClusterNetworkLike(ClusterNetworkEntry item) {
        return new HybridClusterNetworkNested(-1, item);
    }

    public HybridClusterNetworkNested<A> setNewHybridClusterNetworkLike(int index, ClusterNetworkEntry item) {
        return new HybridClusterNetworkNested(index, item);
    }

    public HybridClusterNetworkNested<A> editHybridClusterNetwork(int index) {
        if (this.hybridClusterNetwork.size() <= index) {
            throw new RuntimeException("Can't edit hybridClusterNetwork. Index exceeds size.");
        }
        return this.setNewHybridClusterNetworkLike(index, this.buildHybridClusterNetwork(index));
    }

    public HybridClusterNetworkNested<A> editFirstHybridClusterNetwork() {
        if (this.hybridClusterNetwork.size() == 0) {
            throw new RuntimeException("Can't edit first hybridClusterNetwork. The list is empty.");
        }
        return this.setNewHybridClusterNetworkLike(0, this.buildHybridClusterNetwork(0));
    }

    public HybridClusterNetworkNested<A> editLastHybridClusterNetwork() {
        int index = this.hybridClusterNetwork.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last hybridClusterNetwork. The list is empty.");
        }
        return this.setNewHybridClusterNetworkLike(index, this.buildHybridClusterNetwork(index));
    }

    public HybridClusterNetworkNested<A> editMatchingHybridClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.hybridClusterNetwork.size(); ++i) {
            if (!predicate.test(this.hybridClusterNetwork.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching hybridClusterNetwork. No match found.");
        }
        return this.setNewHybridClusterNetworkLike(index, this.buildHybridClusterNetwork(index));
    }

    public Integer getHybridOverlayVXLANPort() {
        return this.hybridOverlayVXLANPort;
    }

    public A withHybridOverlayVXLANPort(Integer hybridOverlayVXLANPort) {
        this.hybridOverlayVXLANPort = hybridOverlayVXLANPort;
        return (A)((Object)this);
    }

    public boolean hasHybridOverlayVXLANPort() {
        return this.hybridOverlayVXLANPort != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HybridOverlayConfigFluent that = (HybridOverlayConfigFluent)((Object)o);
        if (!Objects.equals(this.hybridClusterNetwork, that.hybridClusterNetwork)) {
            return false;
        }
        if (!Objects.equals(this.hybridOverlayVXLANPort, that.hybridOverlayVXLANPort)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.hybridClusterNetwork, this.hybridOverlayVXLANPort, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.hybridClusterNetwork != null && !this.hybridClusterNetwork.isEmpty()) {
            sb.append("hybridClusterNetwork:");
            sb.append(this.hybridClusterNetwork + ",");
        }
        if (this.hybridOverlayVXLANPort != null) {
            sb.append("hybridOverlayVXLANPort:");
            sb.append(this.hybridOverlayVXLANPort + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class HybridClusterNetworkNested<N>
    extends ClusterNetworkEntryFluent<HybridClusterNetworkNested<N>>
    implements Nested<N> {
        ClusterNetworkEntryBuilder builder;
        int index;

        HybridClusterNetworkNested(int index, ClusterNetworkEntry item) {
            this.index = index;
            this.builder = new ClusterNetworkEntryBuilder(this, item);
        }

        public N and() {
            return (N)HybridOverlayConfigFluent.this.setToHybridClusterNetwork(this.index, this.builder.build());
        }

        public N endHybridClusterNetwork() {
            return this.and();
        }
    }
}

