/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.operator.v1.ProxyConfig;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ProxyConfigFluent<A extends ProxyConfigFluent<A>>
extends BaseFluent<A> {
    private String bindAddress;
    private String iptablesSyncPeriod;
    private Map<String, List<String>> proxyArguments;
    private Map<String, Object> additionalProperties;

    public ProxyConfigFluent() {
    }

    public ProxyConfigFluent(ProxyConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ProxyConfig instance) {
        ProxyConfig proxyConfig = instance = instance != null ? instance : new ProxyConfig();
        if (instance != null) {
            this.withBindAddress(instance.getBindAddress());
            this.withIptablesSyncPeriod(instance.getIptablesSyncPeriod());
            this.withProxyArguments(instance.getProxyArguments());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public A withBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
        return (A)((Object)this);
    }

    public boolean hasBindAddress() {
        return this.bindAddress != null;
    }

    public String getIptablesSyncPeriod() {
        return this.iptablesSyncPeriod;
    }

    public A withIptablesSyncPeriod(String iptablesSyncPeriod) {
        this.iptablesSyncPeriod = iptablesSyncPeriod;
        return (A)((Object)this);
    }

    public boolean hasIptablesSyncPeriod() {
        return this.iptablesSyncPeriod != null;
    }

    public A addToProxyArguments(String key, List<String> value) {
        if (this.proxyArguments == null && key != null && value != null) {
            this.proxyArguments = new LinkedHashMap<String, List<String>>();
        }
        if (key != null && value != null) {
            this.proxyArguments.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToProxyArguments(Map<String, List<String>> map) {
        if (this.proxyArguments == null && map != null) {
            this.proxyArguments = new LinkedHashMap<String, List<String>>();
        }
        if (map != null) {
            this.proxyArguments.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromProxyArguments(String key) {
        if (this.proxyArguments == null) {
            return (A)((Object)this);
        }
        if (key != null && this.proxyArguments != null) {
            this.proxyArguments.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromProxyArguments(Map<String, List<String>> map) {
        if (this.proxyArguments == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.proxyArguments == null) continue;
                this.proxyArguments.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, List<String>> getProxyArguments() {
        return this.proxyArguments;
    }

    public <K, V> A withProxyArguments(Map<String, List<String>> proxyArguments) {
        this.proxyArguments = proxyArguments == null ? null : new LinkedHashMap<String, List<String>>(proxyArguments);
        return (A)((Object)this);
    }

    public boolean hasProxyArguments() {
        return this.proxyArguments != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProxyConfigFluent that = (ProxyConfigFluent)((Object)o);
        if (!Objects.equals(this.bindAddress, that.bindAddress)) {
            return false;
        }
        if (!Objects.equals(this.iptablesSyncPeriod, that.iptablesSyncPeriod)) {
            return false;
        }
        if (!Objects.equals(this.proxyArguments, that.proxyArguments)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.bindAddress, this.iptablesSyncPeriod, this.proxyArguments, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bindAddress != null) {
            sb.append("bindAddress:");
            sb.append(this.bindAddress + ",");
        }
        if (this.iptablesSyncPeriod != null) {
            sb.append("iptablesSyncPeriod:");
            sb.append(this.iptablesSyncPeriod + ",");
        }
        if (this.proxyArguments != null && !this.proxyArguments.isEmpty()) {
            sb.append("proxyArguments:");
            sb.append(this.proxyArguments + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

