/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.controlplane.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.LogEntry;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.LogEntryBuilder;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.LogEntryFluent;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.OutageEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class OutageEntryFluent<A extends OutageEntryFluent<A>>
extends BaseFluent<A> {
    private String end;
    private ArrayList<LogEntryBuilder> endLogs = new ArrayList();
    private String message;
    private String start;
    private ArrayList<LogEntryBuilder> startLogs = new ArrayList();
    private Map<String, Object> additionalProperties;

    public OutageEntryFluent() {
    }

    public OutageEntryFluent(OutageEntry instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(OutageEntry instance) {
        OutageEntry outageEntry = instance = instance != null ? instance : new OutageEntry();
        if (instance != null) {
            this.withEnd(instance.getEnd());
            this.withEndLogs(instance.getEndLogs());
            this.withMessage(instance.getMessage());
            this.withStart(instance.getStart());
            this.withStartLogs(instance.getStartLogs());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getEnd() {
        return this.end;
    }

    public A withEnd(String end) {
        this.end = end;
        return (A)((Object)this);
    }

    public boolean hasEnd() {
        return this.end != null;
    }

    public A addToEndLogs(int index, LogEntry item) {
        if (this.endLogs == null) {
            this.endLogs = new ArrayList();
        }
        LogEntryBuilder builder = new LogEntryBuilder(item);
        if (index < 0 || index >= this.endLogs.size()) {
            this._visitables.get((Object)"endLogs").add(builder);
            this.endLogs.add(builder);
        } else {
            this._visitables.get((Object)"endLogs").add(index, builder);
            this.endLogs.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToEndLogs(int index, LogEntry item) {
        if (this.endLogs == null) {
            this.endLogs = new ArrayList();
        }
        LogEntryBuilder builder = new LogEntryBuilder(item);
        if (index < 0 || index >= this.endLogs.size()) {
            this._visitables.get((Object)"endLogs").add(builder);
            this.endLogs.add(builder);
        } else {
            this._visitables.get((Object)"endLogs").set(index, builder);
            this.endLogs.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToEndLogs(LogEntry ... items) {
        if (this.endLogs == null) {
            this.endLogs = new ArrayList();
        }
        for (LogEntry item : items) {
            LogEntryBuilder builder = new LogEntryBuilder(item);
            this._visitables.get((Object)"endLogs").add(builder);
            this.endLogs.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToEndLogs(Collection<LogEntry> items) {
        if (this.endLogs == null) {
            this.endLogs = new ArrayList();
        }
        for (LogEntry item : items) {
            LogEntryBuilder builder = new LogEntryBuilder(item);
            this._visitables.get((Object)"endLogs").add(builder);
            this.endLogs.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromEndLogs(LogEntry ... items) {
        if (this.endLogs == null) {
            return (A)((Object)this);
        }
        for (LogEntry item : items) {
            LogEntryBuilder builder = new LogEntryBuilder(item);
            this._visitables.get((Object)"endLogs").remove((Object)builder);
            this.endLogs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromEndLogs(Collection<LogEntry> items) {
        if (this.endLogs == null) {
            return (A)((Object)this);
        }
        for (LogEntry item : items) {
            LogEntryBuilder builder = new LogEntryBuilder(item);
            this._visitables.get((Object)"endLogs").remove((Object)builder);
            this.endLogs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromEndLogs(Predicate<LogEntryBuilder> predicate) {
        if (this.endLogs == null) {
            return (A)((Object)this);
        }
        Iterator<LogEntryBuilder> each = this.endLogs.iterator();
        List visitables = this._visitables.get((Object)"endLogs");
        while (each.hasNext()) {
            LogEntryBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<LogEntry> buildEndLogs() {
        return this.endLogs != null ? OutageEntryFluent.build(this.endLogs) : null;
    }

    public LogEntry buildEndLog(int index) {
        return this.endLogs.get(index).build();
    }

    public LogEntry buildFirstEndLog() {
        return this.endLogs.get(0).build();
    }

    public LogEntry buildLastEndLog() {
        return this.endLogs.get(this.endLogs.size() - 1).build();
    }

    public LogEntry buildMatchingEndLog(Predicate<LogEntryBuilder> predicate) {
        for (LogEntryBuilder item : this.endLogs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingEndLog(Predicate<LogEntryBuilder> predicate) {
        for (LogEntryBuilder item : this.endLogs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEndLogs(List<LogEntry> endLogs) {
        if (this.endLogs != null) {
            this._visitables.get((Object)"endLogs").clear();
        }
        if (endLogs != null) {
            this.endLogs = new ArrayList();
            for (LogEntry item : endLogs) {
                this.addToEndLogs(item);
            }
        } else {
            this.endLogs = null;
        }
        return (A)((Object)this);
    }

    public A withEndLogs(LogEntry ... endLogs) {
        if (this.endLogs != null) {
            this.endLogs.clear();
            this._visitables.remove((Object)"endLogs");
        }
        if (endLogs != null) {
            for (LogEntry item : endLogs) {
                this.addToEndLogs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasEndLogs() {
        return this.endLogs != null && !this.endLogs.isEmpty();
    }

    public EndLogsNested<A> addNewEndLog() {
        return new EndLogsNested(-1, null);
    }

    public EndLogsNested<A> addNewEndLogLike(LogEntry item) {
        return new EndLogsNested(-1, item);
    }

    public EndLogsNested<A> setNewEndLogLike(int index, LogEntry item) {
        return new EndLogsNested(index, item);
    }

    public EndLogsNested<A> editEndLog(int index) {
        if (this.endLogs.size() <= index) {
            throw new RuntimeException("Can't edit endLogs. Index exceeds size.");
        }
        return this.setNewEndLogLike(index, this.buildEndLog(index));
    }

    public EndLogsNested<A> editFirstEndLog() {
        if (this.endLogs.size() == 0) {
            throw new RuntimeException("Can't edit first endLogs. The list is empty.");
        }
        return this.setNewEndLogLike(0, this.buildEndLog(0));
    }

    public EndLogsNested<A> editLastEndLog() {
        int index = this.endLogs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last endLogs. The list is empty.");
        }
        return this.setNewEndLogLike(index, this.buildEndLog(index));
    }

    public EndLogsNested<A> editMatchingEndLog(Predicate<LogEntryBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.endLogs.size(); ++i) {
            if (!predicate.test(this.endLogs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching endLogs. No match found.");
        }
        return this.setNewEndLogLike(index, this.buildEndLog(index));
    }

    public String getMessage() {
        return this.message;
    }

    public A withMessage(String message) {
        this.message = message;
        return (A)((Object)this);
    }

    public boolean hasMessage() {
        return this.message != null;
    }

    public String getStart() {
        return this.start;
    }

    public A withStart(String start) {
        this.start = start;
        return (A)((Object)this);
    }

    public boolean hasStart() {
        return this.start != null;
    }

    public A addToStartLogs(int index, LogEntry item) {
        if (this.startLogs == null) {
            this.startLogs = new ArrayList();
        }
        LogEntryBuilder builder = new LogEntryBuilder(item);
        if (index < 0 || index >= this.startLogs.size()) {
            this._visitables.get((Object)"startLogs").add(builder);
            this.startLogs.add(builder);
        } else {
            this._visitables.get((Object)"startLogs").add(index, builder);
            this.startLogs.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToStartLogs(int index, LogEntry item) {
        if (this.startLogs == null) {
            this.startLogs = new ArrayList();
        }
        LogEntryBuilder builder = new LogEntryBuilder(item);
        if (index < 0 || index >= this.startLogs.size()) {
            this._visitables.get((Object)"startLogs").add(builder);
            this.startLogs.add(builder);
        } else {
            this._visitables.get((Object)"startLogs").set(index, builder);
            this.startLogs.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToStartLogs(LogEntry ... items) {
        if (this.startLogs == null) {
            this.startLogs = new ArrayList();
        }
        for (LogEntry item : items) {
            LogEntryBuilder builder = new LogEntryBuilder(item);
            this._visitables.get((Object)"startLogs").add(builder);
            this.startLogs.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToStartLogs(Collection<LogEntry> items) {
        if (this.startLogs == null) {
            this.startLogs = new ArrayList();
        }
        for (LogEntry item : items) {
            LogEntryBuilder builder = new LogEntryBuilder(item);
            this._visitables.get((Object)"startLogs").add(builder);
            this.startLogs.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromStartLogs(LogEntry ... items) {
        if (this.startLogs == null) {
            return (A)((Object)this);
        }
        for (LogEntry item : items) {
            LogEntryBuilder builder = new LogEntryBuilder(item);
            this._visitables.get((Object)"startLogs").remove((Object)builder);
            this.startLogs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromStartLogs(Collection<LogEntry> items) {
        if (this.startLogs == null) {
            return (A)((Object)this);
        }
        for (LogEntry item : items) {
            LogEntryBuilder builder = new LogEntryBuilder(item);
            this._visitables.get((Object)"startLogs").remove((Object)builder);
            this.startLogs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromStartLogs(Predicate<LogEntryBuilder> predicate) {
        if (this.startLogs == null) {
            return (A)((Object)this);
        }
        Iterator<LogEntryBuilder> each = this.startLogs.iterator();
        List visitables = this._visitables.get((Object)"startLogs");
        while (each.hasNext()) {
            LogEntryBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<LogEntry> buildStartLogs() {
        return this.startLogs != null ? OutageEntryFluent.build(this.startLogs) : null;
    }

    public LogEntry buildStartLog(int index) {
        return this.startLogs.get(index).build();
    }

    public LogEntry buildFirstStartLog() {
        return this.startLogs.get(0).build();
    }

    public LogEntry buildLastStartLog() {
        return this.startLogs.get(this.startLogs.size() - 1).build();
    }

    public LogEntry buildMatchingStartLog(Predicate<LogEntryBuilder> predicate) {
        for (LogEntryBuilder item : this.startLogs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingStartLog(Predicate<LogEntryBuilder> predicate) {
        for (LogEntryBuilder item : this.startLogs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withStartLogs(List<LogEntry> startLogs) {
        if (this.startLogs != null) {
            this._visitables.get((Object)"startLogs").clear();
        }
        if (startLogs != null) {
            this.startLogs = new ArrayList();
            for (LogEntry item : startLogs) {
                this.addToStartLogs(item);
            }
        } else {
            this.startLogs = null;
        }
        return (A)((Object)this);
    }

    public A withStartLogs(LogEntry ... startLogs) {
        if (this.startLogs != null) {
            this.startLogs.clear();
            this._visitables.remove((Object)"startLogs");
        }
        if (startLogs != null) {
            for (LogEntry item : startLogs) {
                this.addToStartLogs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasStartLogs() {
        return this.startLogs != null && !this.startLogs.isEmpty();
    }

    public StartLogsNested<A> addNewStartLog() {
        return new StartLogsNested(-1, null);
    }

    public StartLogsNested<A> addNewStartLogLike(LogEntry item) {
        return new StartLogsNested(-1, item);
    }

    public StartLogsNested<A> setNewStartLogLike(int index, LogEntry item) {
        return new StartLogsNested(index, item);
    }

    public StartLogsNested<A> editStartLog(int index) {
        if (this.startLogs.size() <= index) {
            throw new RuntimeException("Can't edit startLogs. Index exceeds size.");
        }
        return this.setNewStartLogLike(index, this.buildStartLog(index));
    }

    public StartLogsNested<A> editFirstStartLog() {
        if (this.startLogs.size() == 0) {
            throw new RuntimeException("Can't edit first startLogs. The list is empty.");
        }
        return this.setNewStartLogLike(0, this.buildStartLog(0));
    }

    public StartLogsNested<A> editLastStartLog() {
        int index = this.startLogs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last startLogs. The list is empty.");
        }
        return this.setNewStartLogLike(index, this.buildStartLog(index));
    }

    public StartLogsNested<A> editMatchingStartLog(Predicate<LogEntryBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.startLogs.size(); ++i) {
            if (!predicate.test(this.startLogs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching startLogs. No match found.");
        }
        return this.setNewStartLogLike(index, this.buildStartLog(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OutageEntryFluent that = (OutageEntryFluent)((Object)o);
        if (!Objects.equals(this.end, that.end)) {
            return false;
        }
        if (!Objects.equals(this.endLogs, that.endLogs)) {
            return false;
        }
        if (!Objects.equals(this.message, that.message)) {
            return false;
        }
        if (!Objects.equals(this.start, that.start)) {
            return false;
        }
        if (!Objects.equals(this.startLogs, that.startLogs)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.end, this.endLogs, this.message, this.start, this.startLogs, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.end != null) {
            sb.append("end:");
            sb.append(this.end + ",");
        }
        if (this.endLogs != null && !this.endLogs.isEmpty()) {
            sb.append("endLogs:");
            sb.append(this.endLogs + ",");
        }
        if (this.message != null) {
            sb.append("message:");
            sb.append(this.message + ",");
        }
        if (this.start != null) {
            sb.append("start:");
            sb.append(this.start + ",");
        }
        if (this.startLogs != null && !this.startLogs.isEmpty()) {
            sb.append("startLogs:");
            sb.append(this.startLogs + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class StartLogsNested<N>
    extends LogEntryFluent<StartLogsNested<N>>
    implements Nested<N> {
        LogEntryBuilder builder;
        int index;

        StartLogsNested(int index, LogEntry item) {
            this.index = index;
            this.builder = new LogEntryBuilder(this, item);
        }

        public N and() {
            return (N)OutageEntryFluent.this.setToStartLogs(this.index, this.builder.build());
        }

        public N endStartLog() {
            return this.and();
        }
    }

    public class EndLogsNested<N>
    extends LogEntryFluent<EndLogsNested<N>>
    implements Nested<N> {
        LogEntryBuilder builder;
        int index;

        EndLogsNested(int index, LogEntry item) {
            this.index = index;
            this.builder = new LogEntryBuilder(this, item);
        }

        public N and() {
            return (N)OutageEntryFluent.this.setToEndLogs(this.index, this.builder.build());
        }

        public N endEndLog() {
            return this.and();
        }
    }
}

