/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operator.v1.MachineManager;
import io.fabric8.openshift.api.model.operator.v1.MachineManagerBuilder;
import io.fabric8.openshift.api.model.operator.v1.MachineManagerFluent;
import io.fabric8.openshift.api.model.operator.v1.ManagedBootImages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ManagedBootImagesFluent<A extends ManagedBootImagesFluent<A>>
extends BaseFluent<A> {
    private ArrayList<MachineManagerBuilder> machineManagers = new ArrayList();
    private Map<String, Object> additionalProperties;

    public ManagedBootImagesFluent() {
    }

    public ManagedBootImagesFluent(ManagedBootImages instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ManagedBootImages instance) {
        ManagedBootImages managedBootImages = instance = instance != null ? instance : new ManagedBootImages();
        if (instance != null) {
            this.withMachineManagers(instance.getMachineManagers());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToMachineManagers(int index, MachineManager item) {
        if (this.machineManagers == null) {
            this.machineManagers = new ArrayList();
        }
        MachineManagerBuilder builder = new MachineManagerBuilder(item);
        if (index < 0 || index >= this.machineManagers.size()) {
            this._visitables.get((Object)"machineManagers").add(builder);
            this.machineManagers.add(builder);
        } else {
            this._visitables.get((Object)"machineManagers").add(index, builder);
            this.machineManagers.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToMachineManagers(int index, MachineManager item) {
        if (this.machineManagers == null) {
            this.machineManagers = new ArrayList();
        }
        MachineManagerBuilder builder = new MachineManagerBuilder(item);
        if (index < 0 || index >= this.machineManagers.size()) {
            this._visitables.get((Object)"machineManagers").add(builder);
            this.machineManagers.add(builder);
        } else {
            this._visitables.get((Object)"machineManagers").set(index, builder);
            this.machineManagers.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToMachineManagers(MachineManager ... items) {
        if (this.machineManagers == null) {
            this.machineManagers = new ArrayList();
        }
        for (MachineManager item : items) {
            MachineManagerBuilder builder = new MachineManagerBuilder(item);
            this._visitables.get((Object)"machineManagers").add(builder);
            this.machineManagers.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToMachineManagers(Collection<MachineManager> items) {
        if (this.machineManagers == null) {
            this.machineManagers = new ArrayList();
        }
        for (MachineManager item : items) {
            MachineManagerBuilder builder = new MachineManagerBuilder(item);
            this._visitables.get((Object)"machineManagers").add(builder);
            this.machineManagers.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromMachineManagers(MachineManager ... items) {
        if (this.machineManagers == null) {
            return (A)((Object)this);
        }
        for (MachineManager item : items) {
            MachineManagerBuilder builder = new MachineManagerBuilder(item);
            this._visitables.get((Object)"machineManagers").remove((Object)builder);
            this.machineManagers.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromMachineManagers(Collection<MachineManager> items) {
        if (this.machineManagers == null) {
            return (A)((Object)this);
        }
        for (MachineManager item : items) {
            MachineManagerBuilder builder = new MachineManagerBuilder(item);
            this._visitables.get((Object)"machineManagers").remove((Object)builder);
            this.machineManagers.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromMachineManagers(Predicate<MachineManagerBuilder> predicate) {
        if (this.machineManagers == null) {
            return (A)((Object)this);
        }
        Iterator<MachineManagerBuilder> each = this.machineManagers.iterator();
        List visitables = this._visitables.get((Object)"machineManagers");
        while (each.hasNext()) {
            MachineManagerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<MachineManager> buildMachineManagers() {
        return this.machineManagers != null ? ManagedBootImagesFluent.build(this.machineManagers) : null;
    }

    public MachineManager buildMachineManager(int index) {
        return this.machineManagers.get(index).build();
    }

    public MachineManager buildFirstMachineManager() {
        return this.machineManagers.get(0).build();
    }

    public MachineManager buildLastMachineManager() {
        return this.machineManagers.get(this.machineManagers.size() - 1).build();
    }

    public MachineManager buildMatchingMachineManager(Predicate<MachineManagerBuilder> predicate) {
        for (MachineManagerBuilder item : this.machineManagers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingMachineManager(Predicate<MachineManagerBuilder> predicate) {
        for (MachineManagerBuilder item : this.machineManagers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withMachineManagers(List<MachineManager> machineManagers) {
        if (this.machineManagers != null) {
            this._visitables.get((Object)"machineManagers").clear();
        }
        if (machineManagers != null) {
            this.machineManagers = new ArrayList();
            for (MachineManager item : machineManagers) {
                this.addToMachineManagers(item);
            }
        } else {
            this.machineManagers = null;
        }
        return (A)((Object)this);
    }

    public A withMachineManagers(MachineManager ... machineManagers) {
        if (this.machineManagers != null) {
            this.machineManagers.clear();
            this._visitables.remove((Object)"machineManagers");
        }
        if (machineManagers != null) {
            for (MachineManager item : machineManagers) {
                this.addToMachineManagers(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasMachineManagers() {
        return this.machineManagers != null && !this.machineManagers.isEmpty();
    }

    public MachineManagersNested<A> addNewMachineManager() {
        return new MachineManagersNested(-1, null);
    }

    public MachineManagersNested<A> addNewMachineManagerLike(MachineManager item) {
        return new MachineManagersNested(-1, item);
    }

    public MachineManagersNested<A> setNewMachineManagerLike(int index, MachineManager item) {
        return new MachineManagersNested(index, item);
    }

    public MachineManagersNested<A> editMachineManager(int index) {
        if (this.machineManagers.size() <= index) {
            throw new RuntimeException("Can't edit machineManagers. Index exceeds size.");
        }
        return this.setNewMachineManagerLike(index, this.buildMachineManager(index));
    }

    public MachineManagersNested<A> editFirstMachineManager() {
        if (this.machineManagers.size() == 0) {
            throw new RuntimeException("Can't edit first machineManagers. The list is empty.");
        }
        return this.setNewMachineManagerLike(0, this.buildMachineManager(0));
    }

    public MachineManagersNested<A> editLastMachineManager() {
        int index = this.machineManagers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last machineManagers. The list is empty.");
        }
        return this.setNewMachineManagerLike(index, this.buildMachineManager(index));
    }

    public MachineManagersNested<A> editMatchingMachineManager(Predicate<MachineManagerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.machineManagers.size(); ++i) {
            if (!predicate.test(this.machineManagers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching machineManagers. No match found.");
        }
        return this.setNewMachineManagerLike(index, this.buildMachineManager(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ManagedBootImagesFluent that = (ManagedBootImagesFluent)((Object)o);
        if (!Objects.equals(this.machineManagers, that.machineManagers)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.machineManagers, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.machineManagers != null && !this.machineManagers.isEmpty()) {
            sb.append("machineManagers:");
            sb.append(this.machineManagers + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MachineManagersNested<N>
    extends MachineManagerFluent<MachineManagersNested<N>>
    implements Nested<N> {
        MachineManagerBuilder builder;
        int index;

        MachineManagersNested(int index, MachineManager item) {
            this.index = index;
            this.builder = new MachineManagerBuilder(this, item);
        }

        public N and() {
            return (N)ManagedBootImagesFluent.this.setToMachineManagers(this.index, this.builder.build());
        }

        public N endMachineManager() {
            return this.and();
        }
    }
}

