package io.fabric8.openshift.api.model.storageversionmigrator.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class MigrationConditionBuilder extends MigrationConditionFluent<MigrationConditionBuilder> implements VisitableBuilder<MigrationCondition,MigrationConditionBuilder>{
  public MigrationConditionBuilder() {
    this(new MigrationCondition());
  }
  
  public MigrationConditionBuilder(MigrationConditionFluent<?> fluent) {
    this(fluent, new MigrationCondition());
  }
  
  public MigrationConditionBuilder(MigrationConditionFluent<?> fluent,MigrationCondition instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public MigrationConditionBuilder(MigrationCondition instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  MigrationConditionFluent<?> fluent;
  
  public MigrationCondition build() {
    MigrationCondition buildable = new MigrationCondition(fluent.getLastUpdateTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}