/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.tuned.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.tuned.v1.OperandConfig;
import io.fabric8.openshift.api.model.tuned.v1.OperandConfigBuilder;
import io.fabric8.openshift.api.model.tuned.v1.OperandConfigFluentImpl;
import io.fabric8.openshift.api.model.tuned.v1.TunedMatch;
import io.fabric8.openshift.api.model.tuned.v1.TunedMatchBuilder;
import io.fabric8.openshift.api.model.tuned.v1.TunedMatchFluentImpl;
import io.fabric8.openshift.api.model.tuned.v1.TunedRecommend;
import io.fabric8.openshift.api.model.tuned.v1.TunedRecommendFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class TunedRecommendFluentImpl<A extends TunedRecommendFluent<A>>
extends BaseFluent<A>
implements TunedRecommendFluent<A> {
    private Map<String, String> machineConfigLabels;
    private List<TunedMatchBuilder> match = new ArrayList<TunedMatchBuilder>();
    private OperandConfigBuilder operand;
    private Long priority;
    private String profile;
    private Map<String, Object> additionalProperties;

    public TunedRecommendFluentImpl() {
    }

    public TunedRecommendFluentImpl(TunedRecommend instance) {
        this.withMachineConfigLabels(instance.getMachineConfigLabels());
        this.withMatch(instance.getMatch());
        this.withOperand(instance.getOperand());
        this.withPriority(instance.getPriority());
        this.withProfile(instance.getProfile());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToMachineConfigLabels(String key, String value) {
        if (this.machineConfigLabels == null && key != null && value != null) {
            this.machineConfigLabels = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.machineConfigLabels.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToMachineConfigLabels(Map<String, String> map) {
        if (this.machineConfigLabels == null && map != null) {
            this.machineConfigLabels = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.machineConfigLabels.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromMachineConfigLabels(String key) {
        if (this.machineConfigLabels == null) {
            return (A)this;
        }
        if (key != null && this.machineConfigLabels != null) {
            this.machineConfigLabels.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromMachineConfigLabels(Map<String, String> map) {
        if (this.machineConfigLabels == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.machineConfigLabels == null) continue;
                this.machineConfigLabels.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getMachineConfigLabels() {
        return this.machineConfigLabels;
    }

    @Override
    public <K, V> A withMachineConfigLabels(Map<String, String> machineConfigLabels) {
        this.machineConfigLabels = machineConfigLabels == null ? null : new LinkedHashMap<String, String>(machineConfigLabels);
        return (A)this;
    }

    @Override
    public Boolean hasMachineConfigLabels() {
        return this.machineConfigLabels != null;
    }

    @Override
    public A addToMatch(Integer index, TunedMatch item) {
        if (this.match == null) {
            this.match = new ArrayList<TunedMatchBuilder>();
        }
        TunedMatchBuilder builder = new TunedMatchBuilder(item);
        this._visitables.get((Object)"match").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"match").size(), builder);
        this.match.add(index >= 0 ? index.intValue() : this.match.size(), builder);
        return (A)this;
    }

    @Override
    public A setToMatch(Integer index, TunedMatch item) {
        if (this.match == null) {
            this.match = new ArrayList<TunedMatchBuilder>();
        }
        TunedMatchBuilder builder = new TunedMatchBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"match").size()) {
            this._visitables.get((Object)"match").add(builder);
        } else {
            this._visitables.get((Object)"match").set(index, builder);
        }
        if (index < 0 || index >= this.match.size()) {
            this.match.add(builder);
        } else {
            this.match.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToMatch(TunedMatch ... items) {
        if (this.match == null) {
            this.match = new ArrayList<TunedMatchBuilder>();
        }
        for (TunedMatch item : items) {
            TunedMatchBuilder builder = new TunedMatchBuilder(item);
            this._visitables.get((Object)"match").add(builder);
            this.match.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToMatch(Collection<TunedMatch> items) {
        if (this.match == null) {
            this.match = new ArrayList<TunedMatchBuilder>();
        }
        for (TunedMatch item : items) {
            TunedMatchBuilder builder = new TunedMatchBuilder(item);
            this._visitables.get((Object)"match").add(builder);
            this.match.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromMatch(TunedMatch ... items) {
        for (TunedMatch item : items) {
            TunedMatchBuilder builder = new TunedMatchBuilder(item);
            this._visitables.get((Object)"match").remove(builder);
            if (this.match == null) continue;
            this.match.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromMatch(Collection<TunedMatch> items) {
        for (TunedMatch item : items) {
            TunedMatchBuilder builder = new TunedMatchBuilder(item);
            this._visitables.get((Object)"match").remove(builder);
            if (this.match == null) continue;
            this.match.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromMatch(Predicate<TunedMatchBuilder> predicate) {
        if (this.match == null) {
            return (A)this;
        }
        Iterator<TunedMatchBuilder> each = this.match.iterator();
        List visitables = this._visitables.get((Object)"match");
        while (each.hasNext()) {
            TunedMatchBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<TunedMatch> getMatch() {
        return TunedRecommendFluentImpl.build(this.match);
    }

    @Override
    public List<TunedMatch> buildMatch() {
        return TunedRecommendFluentImpl.build(this.match);
    }

    @Override
    public TunedMatch buildMatch(Integer index) {
        return this.match.get(index).build();
    }

    @Override
    public TunedMatch buildFirstMatch() {
        return this.match.get(0).build();
    }

    @Override
    public TunedMatch buildLastMatch() {
        return this.match.get(this.match.size() - 1).build();
    }

    @Override
    public TunedMatch buildMatchingMatch(Predicate<TunedMatchBuilder> predicate) {
        for (TunedMatchBuilder item : this.match) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingMatch(Predicate<TunedMatchBuilder> predicate) {
        for (TunedMatchBuilder item : this.match) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withMatch(List<TunedMatch> match) {
        if (this.match != null) {
            this._visitables.get((Object)"match").removeAll(this.match);
        }
        if (match != null) {
            this.match = new ArrayList<TunedMatchBuilder>();
            for (TunedMatch item : match) {
                this.addToMatch(item);
            }
        } else {
            this.match = null;
        }
        return (A)this;
    }

    @Override
    public A withMatch(TunedMatch ... match) {
        if (this.match != null) {
            this.match.clear();
        }
        if (match != null) {
            for (TunedMatch item : match) {
                this.addToMatch(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasMatch() {
        return this.match != null && !this.match.isEmpty();
    }

    @Override
    public TunedRecommendFluent.MatchNested<A> addNewMatch() {
        return new MatchNestedImpl();
    }

    @Override
    public TunedRecommendFluent.MatchNested<A> addNewMatchLike(TunedMatch item) {
        return new MatchNestedImpl(-1, item);
    }

    @Override
    public TunedRecommendFluent.MatchNested<A> setNewMatchLike(Integer index, TunedMatch item) {
        return new MatchNestedImpl(index, item);
    }

    @Override
    public TunedRecommendFluent.MatchNested<A> editMatch(Integer index) {
        if (this.match.size() <= index) {
            throw new RuntimeException("Can't edit match. Index exceeds size.");
        }
        return this.setNewMatchLike(index, this.buildMatch(index));
    }

    @Override
    public TunedRecommendFluent.MatchNested<A> editFirstMatch() {
        if (this.match.size() == 0) {
            throw new RuntimeException("Can't edit first match. The list is empty.");
        }
        return this.setNewMatchLike(0, this.buildMatch(0));
    }

    @Override
    public TunedRecommendFluent.MatchNested<A> editLastMatch() {
        int index = this.match.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last match. The list is empty.");
        }
        return this.setNewMatchLike(index, this.buildMatch(index));
    }

    @Override
    public TunedRecommendFluent.MatchNested<A> editMatchingMatch(Predicate<TunedMatchBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.match.size(); ++i) {
            if (!predicate.test(this.match.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching match. No match found.");
        }
        return this.setNewMatchLike(index, this.buildMatch(index));
    }

    @Override
    @Deprecated
    public OperandConfig getOperand() {
        return this.operand != null ? this.operand.build() : null;
    }

    @Override
    public OperandConfig buildOperand() {
        return this.operand != null ? this.operand.build() : null;
    }

    @Override
    public A withOperand(OperandConfig operand) {
        this._visitables.get((Object)"operand").remove(this.operand);
        if (operand != null) {
            this.operand = new OperandConfigBuilder(operand);
            this._visitables.get((Object)"operand").add(this.operand);
        }
        return (A)this;
    }

    @Override
    public Boolean hasOperand() {
        return this.operand != null;
    }

    @Override
    public A withNewOperand(Boolean debug) {
        return this.withOperand(new OperandConfig(debug));
    }

    @Override
    public TunedRecommendFluent.OperandNested<A> withNewOperand() {
        return new OperandNestedImpl();
    }

    @Override
    public TunedRecommendFluent.OperandNested<A> withNewOperandLike(OperandConfig item) {
        return new OperandNestedImpl(item);
    }

    @Override
    public TunedRecommendFluent.OperandNested<A> editOperand() {
        return this.withNewOperandLike(this.getOperand());
    }

    @Override
    public TunedRecommendFluent.OperandNested<A> editOrNewOperand() {
        return this.withNewOperandLike(this.getOperand() != null ? this.getOperand() : new OperandConfigBuilder().build());
    }

    @Override
    public TunedRecommendFluent.OperandNested<A> editOrNewOperandLike(OperandConfig item) {
        return this.withNewOperandLike(this.getOperand() != null ? this.getOperand() : item);
    }

    @Override
    public Long getPriority() {
        return this.priority;
    }

    @Override
    public A withPriority(Long priority) {
        this.priority = priority;
        return (A)this;
    }

    @Override
    public Boolean hasPriority() {
        return this.priority != null;
    }

    @Override
    public String getProfile() {
        return this.profile;
    }

    @Override
    public A withProfile(String profile) {
        this.profile = profile;
        return (A)this;
    }

    @Override
    public Boolean hasProfile() {
        return this.profile != null;
    }

    @Override
    @Deprecated
    public A withNewProfile(String arg0) {
        return this.withProfile(new String(arg0));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TunedRecommendFluentImpl that = (TunedRecommendFluentImpl)o;
        if (this.machineConfigLabels != null ? !this.machineConfigLabels.equals(that.machineConfigLabels) : that.machineConfigLabels != null) {
            return false;
        }
        if (this.match != null ? !this.match.equals(that.match) : that.match != null) {
            return false;
        }
        if (this.operand != null ? !this.operand.equals(that.operand) : that.operand != null) {
            return false;
        }
        if (this.priority != null ? !this.priority.equals(that.priority) : that.priority != null) {
            return false;
        }
        if (this.profile != null ? !this.profile.equals(that.profile) : that.profile != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.machineConfigLabels, this.match, this.operand, this.priority, this.profile, this.additionalProperties, super.hashCode());
    }

    public class OperandNestedImpl<N>
    extends OperandConfigFluentImpl<TunedRecommendFluent.OperandNested<N>>
    implements TunedRecommendFluent.OperandNested<N>,
    Nested<N> {
        OperandConfigBuilder builder;

        OperandNestedImpl(OperandConfig item) {
            this.builder = new OperandConfigBuilder(this, item);
        }

        OperandNestedImpl() {
            this.builder = new OperandConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)TunedRecommendFluentImpl.this.withOperand(this.builder.build());
        }

        @Override
        public N endOperand() {
            return this.and();
        }
    }

    public class MatchNestedImpl<N>
    extends TunedMatchFluentImpl<TunedRecommendFluent.MatchNested<N>>
    implements TunedRecommendFluent.MatchNested<N>,
    Nested<N> {
        TunedMatchBuilder builder;
        Integer index;

        MatchNestedImpl(Integer index, TunedMatch item) {
            this.index = index;
            this.builder = new TunedMatchBuilder(this, item);
        }

        MatchNestedImpl() {
            this.index = -1;
            this.builder = new TunedMatchBuilder(this);
        }

        @Override
        public N and() {
            return (N)TunedRecommendFluentImpl.this.setToMatch(this.index, this.builder.build());
        }

        @Override
        public N endMatch() {
            return this.and();
        }
    }
}

