package io.fabric8.openshift.api.model.tuned.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class TunedProfileBuilder extends TunedProfileFluent<TunedProfileBuilder> implements VisitableBuilder<TunedProfile,TunedProfileBuilder>{
  public TunedProfileBuilder() {
    this(new TunedProfile());
  }
  
  public TunedProfileBuilder(TunedProfileFluent<?> fluent) {
    this(fluent, new TunedProfile());
  }
  
  public TunedProfileBuilder(TunedProfileFluent<?> fluent,TunedProfile instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public TunedProfileBuilder(TunedProfile instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  TunedProfileFluent<?> fluent;
  
  public TunedProfile build() {
    TunedProfile buildable = new TunedProfile(fluent.getData(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}