package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class DockerStrategyOptionsBuilder extends DockerStrategyOptionsFluent<DockerStrategyOptionsBuilder> implements VisitableBuilder<DockerStrategyOptions,DockerStrategyOptionsBuilder>{
  public DockerStrategyOptionsBuilder() {
    this(new DockerStrategyOptions());
  }
  
  public DockerStrategyOptionsBuilder(DockerStrategyOptionsFluent<?> fluent) {
    this(fluent, new DockerStrategyOptions());
  }
  
  public DockerStrategyOptionsBuilder(DockerStrategyOptionsFluent<?> fluent,DockerStrategyOptions instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public DockerStrategyOptionsBuilder(DockerStrategyOptions instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  DockerStrategyOptionsFluent<?> fluent;
  
  public DockerStrategyOptions build() {
    DockerStrategyOptions buildable = new DockerStrategyOptions(fluent.getBuildArgs(),fluent.getNoCache());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}