/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Condition;
import io.fabric8.openshift.api.model.config.v1.ConditionalUpdate;
import io.fabric8.openshift.api.model.config.v1.ConditionalUpdateRisk;
import io.fabric8.openshift.api.model.config.v1.ConditionalUpdateRiskBuilder;
import io.fabric8.openshift.api.model.config.v1.ConditionalUpdateRiskFluent;
import io.fabric8.openshift.api.model.config.v1.Release;
import io.fabric8.openshift.api.model.config.v1.ReleaseBuilder;
import io.fabric8.openshift.api.model.config.v1.ReleaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ConditionalUpdateFluent<A extends ConditionalUpdateFluent<A>>
extends BaseFluent<A> {
    private List<Condition> conditions = new ArrayList<Condition>();
    private ReleaseBuilder release;
    private ArrayList<ConditionalUpdateRiskBuilder> risks = new ArrayList();
    private Map<String, Object> additionalProperties;

    public ConditionalUpdateFluent() {
    }

    public ConditionalUpdateFluent(ConditionalUpdate instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ConditionalUpdate instance) {
        ConditionalUpdate conditionalUpdate = instance = instance != null ? instance : new ConditionalUpdate();
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withRelease(instance.getRelease());
            this.withRisks(instance.getRisks());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)((Object)this);
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)((Object)this);
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)((Object)this);
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public Condition getCondition(int index) {
        return this.conditions.get(index);
    }

    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<Condition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public Release buildRelease() {
        return this.release != null ? this.release.build() : null;
    }

    public A withRelease(Release release) {
        this._visitables.remove((Object)"release");
        if (release != null) {
            this.release = new ReleaseBuilder(release);
            this._visitables.get((Object)"release").add(this.release);
        } else {
            this.release = null;
            this._visitables.get((Object)"release").remove((Object)this.release);
        }
        return (A)((Object)this);
    }

    public boolean hasRelease() {
        return this.release != null;
    }

    public ReleaseNested<A> withNewRelease() {
        return new ReleaseNested(null);
    }

    public ReleaseNested<A> withNewReleaseLike(Release item) {
        return new ReleaseNested(item);
    }

    public ReleaseNested<A> editRelease() {
        return this.withNewReleaseLike(Optional.ofNullable(this.buildRelease()).orElse(null));
    }

    public ReleaseNested<A> editOrNewRelease() {
        return this.withNewReleaseLike(Optional.ofNullable(this.buildRelease()).orElse(new ReleaseBuilder().build()));
    }

    public ReleaseNested<A> editOrNewReleaseLike(Release item) {
        return this.withNewReleaseLike(Optional.ofNullable(this.buildRelease()).orElse(item));
    }

    public A addToRisks(int index, ConditionalUpdateRisk item) {
        if (this.risks == null) {
            this.risks = new ArrayList();
        }
        ConditionalUpdateRiskBuilder builder = new ConditionalUpdateRiskBuilder(item);
        if (index < 0 || index >= this.risks.size()) {
            this._visitables.get((Object)"risks").add(builder);
            this.risks.add(builder);
        } else {
            this._visitables.get((Object)"risks").add(index, builder);
            this.risks.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToRisks(int index, ConditionalUpdateRisk item) {
        if (this.risks == null) {
            this.risks = new ArrayList();
        }
        ConditionalUpdateRiskBuilder builder = new ConditionalUpdateRiskBuilder(item);
        if (index < 0 || index >= this.risks.size()) {
            this._visitables.get((Object)"risks").add(builder);
            this.risks.add(builder);
        } else {
            this._visitables.get((Object)"risks").set(index, builder);
            this.risks.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToRisks(ConditionalUpdateRisk ... items) {
        if (this.risks == null) {
            this.risks = new ArrayList();
        }
        for (ConditionalUpdateRisk item : items) {
            ConditionalUpdateRiskBuilder builder = new ConditionalUpdateRiskBuilder(item);
            this._visitables.get((Object)"risks").add(builder);
            this.risks.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToRisks(Collection<ConditionalUpdateRisk> items) {
        if (this.risks == null) {
            this.risks = new ArrayList();
        }
        for (ConditionalUpdateRisk item : items) {
            ConditionalUpdateRiskBuilder builder = new ConditionalUpdateRiskBuilder(item);
            this._visitables.get((Object)"risks").add(builder);
            this.risks.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromRisks(ConditionalUpdateRisk ... items) {
        if (this.risks == null) {
            return (A)((Object)this);
        }
        for (ConditionalUpdateRisk item : items) {
            ConditionalUpdateRiskBuilder builder = new ConditionalUpdateRiskBuilder(item);
            this._visitables.get((Object)"risks").remove((Object)builder);
            this.risks.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromRisks(Collection<ConditionalUpdateRisk> items) {
        if (this.risks == null) {
            return (A)((Object)this);
        }
        for (ConditionalUpdateRisk item : items) {
            ConditionalUpdateRiskBuilder builder = new ConditionalUpdateRiskBuilder(item);
            this._visitables.get((Object)"risks").remove((Object)builder);
            this.risks.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromRisks(Predicate<ConditionalUpdateRiskBuilder> predicate) {
        if (this.risks == null) {
            return (A)((Object)this);
        }
        Iterator<ConditionalUpdateRiskBuilder> each = this.risks.iterator();
        List visitables = this._visitables.get((Object)"risks");
        while (each.hasNext()) {
            ConditionalUpdateRiskBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ConditionalUpdateRisk> buildRisks() {
        return this.risks != null ? ConditionalUpdateFluent.build(this.risks) : null;
    }

    public ConditionalUpdateRisk buildRisk(int index) {
        return this.risks.get(index).build();
    }

    public ConditionalUpdateRisk buildFirstRisk() {
        return this.risks.get(0).build();
    }

    public ConditionalUpdateRisk buildLastRisk() {
        return this.risks.get(this.risks.size() - 1).build();
    }

    public ConditionalUpdateRisk buildMatchingRisk(Predicate<ConditionalUpdateRiskBuilder> predicate) {
        for (ConditionalUpdateRiskBuilder item : this.risks) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingRisk(Predicate<ConditionalUpdateRiskBuilder> predicate) {
        for (ConditionalUpdateRiskBuilder item : this.risks) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRisks(List<ConditionalUpdateRisk> risks) {
        if (this.risks != null) {
            this._visitables.get((Object)"risks").clear();
        }
        if (risks != null) {
            this.risks = new ArrayList();
            for (ConditionalUpdateRisk item : risks) {
                this.addToRisks(item);
            }
        } else {
            this.risks = null;
        }
        return (A)((Object)this);
    }

    public A withRisks(ConditionalUpdateRisk ... risks) {
        if (this.risks != null) {
            this.risks.clear();
            this._visitables.remove((Object)"risks");
        }
        if (risks != null) {
            for (ConditionalUpdateRisk item : risks) {
                this.addToRisks(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasRisks() {
        return this.risks != null && !this.risks.isEmpty();
    }

    public RisksNested<A> addNewRisk() {
        return new RisksNested(-1, null);
    }

    public RisksNested<A> addNewRiskLike(ConditionalUpdateRisk item) {
        return new RisksNested(-1, item);
    }

    public RisksNested<A> setNewRiskLike(int index, ConditionalUpdateRisk item) {
        return new RisksNested(index, item);
    }

    public RisksNested<A> editRisk(int index) {
        if (this.risks.size() <= index) {
            throw new RuntimeException("Can't edit risks. Index exceeds size.");
        }
        return this.setNewRiskLike(index, this.buildRisk(index));
    }

    public RisksNested<A> editFirstRisk() {
        if (this.risks.size() == 0) {
            throw new RuntimeException("Can't edit first risks. The list is empty.");
        }
        return this.setNewRiskLike(0, this.buildRisk(0));
    }

    public RisksNested<A> editLastRisk() {
        int index = this.risks.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last risks. The list is empty.");
        }
        return this.setNewRiskLike(index, this.buildRisk(index));
    }

    public RisksNested<A> editMatchingRisk(Predicate<ConditionalUpdateRiskBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.risks.size(); ++i) {
            if (!predicate.test(this.risks.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching risks. No match found.");
        }
        return this.setNewRiskLike(index, this.buildRisk(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConditionalUpdateFluent that = (ConditionalUpdateFluent)((Object)o);
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals((Object)this.release, (Object)that.release)) {
            return false;
        }
        if (!Objects.equals(this.risks, that.risks)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.conditions, this.release, this.risks, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.release != null) {
            sb.append("release:");
            sb.append((Object)((Object)this.release) + ",");
        }
        if (this.risks != null && !this.risks.isEmpty()) {
            sb.append("risks:");
            sb.append(this.risks + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class RisksNested<N>
    extends ConditionalUpdateRiskFluent<RisksNested<N>>
    implements Nested<N> {
        ConditionalUpdateRiskBuilder builder;
        int index;

        RisksNested(int index, ConditionalUpdateRisk item) {
            this.index = index;
            this.builder = new ConditionalUpdateRiskBuilder(this, item);
        }

        public N and() {
            return (N)ConditionalUpdateFluent.this.setToRisks(this.index, this.builder.build());
        }

        public N endRisk() {
            return this.and();
        }
    }

    public class ReleaseNested<N>
    extends ReleaseFluent<ReleaseNested<N>>
    implements Nested<N> {
        ReleaseBuilder builder;

        ReleaseNested(Release item) {
            this.builder = new ReleaseBuilder(this, item);
        }

        public N and() {
            return (N)ConditionalUpdateFluent.this.withRelease(this.builder.build());
        }

        public N endRelease() {
            return this.and();
        }
    }
}

