/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.openshift.api.model.BuildVolume;
import io.fabric8.openshift.api.model.BuildVolumeBuilder;
import io.fabric8.openshift.api.model.BuildVolumeFluent;
import io.fabric8.openshift.api.model.DockerBuildStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class DockerBuildStrategyFluent<A extends DockerBuildStrategyFluent<A>>
extends BaseFluent<A> {
    private ArrayList<EnvVarBuilder> buildArgs = new ArrayList();
    private String dockerfilePath;
    private ArrayList<EnvVarBuilder> env = new ArrayList();
    private Boolean forcePull;
    private ObjectReferenceBuilder from;
    private String imageOptimizationPolicy;
    private Boolean noCache;
    private LocalObjectReferenceBuilder pullSecret;
    private ArrayList<BuildVolumeBuilder> volumes = new ArrayList();
    private Map<String, Object> additionalProperties;

    public DockerBuildStrategyFluent() {
    }

    public DockerBuildStrategyFluent(DockerBuildStrategy instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(DockerBuildStrategy instance) {
        DockerBuildStrategy dockerBuildStrategy = instance = instance != null ? instance : new DockerBuildStrategy();
        if (instance != null) {
            this.withBuildArgs(instance.getBuildArgs());
            this.withDockerfilePath(instance.getDockerfilePath());
            this.withEnv(instance.getEnv());
            this.withForcePull(instance.getForcePull());
            this.withFrom(instance.getFrom());
            this.withImageOptimizationPolicy(instance.getImageOptimizationPolicy());
            this.withNoCache(instance.getNoCache());
            this.withPullSecret(instance.getPullSecret());
            this.withVolumes(instance.getVolumes());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToBuildArgs(int index, EnvVar item) {
        if (this.buildArgs == null) {
            this.buildArgs = new ArrayList();
        }
        EnvVarBuilder builder = new EnvVarBuilder(item);
        if (index < 0 || index >= this.buildArgs.size()) {
            this._visitables.get((Object)"buildArgs").add(builder);
            this.buildArgs.add(builder);
        } else {
            this._visitables.get((Object)"buildArgs").add(index, builder);
            this.buildArgs.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToBuildArgs(int index, EnvVar item) {
        if (this.buildArgs == null) {
            this.buildArgs = new ArrayList();
        }
        EnvVarBuilder builder = new EnvVarBuilder(item);
        if (index < 0 || index >= this.buildArgs.size()) {
            this._visitables.get((Object)"buildArgs").add(builder);
            this.buildArgs.add(builder);
        } else {
            this._visitables.get((Object)"buildArgs").set(index, builder);
            this.buildArgs.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToBuildArgs(EnvVar ... items) {
        if (this.buildArgs == null) {
            this.buildArgs = new ArrayList();
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get((Object)"buildArgs").add(builder);
            this.buildArgs.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToBuildArgs(Collection<EnvVar> items) {
        if (this.buildArgs == null) {
            this.buildArgs = new ArrayList();
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get((Object)"buildArgs").add(builder);
            this.buildArgs.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromBuildArgs(EnvVar ... items) {
        if (this.buildArgs == null) {
            return (A)((Object)this);
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get((Object)"buildArgs").remove(builder);
            this.buildArgs.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromBuildArgs(Collection<EnvVar> items) {
        if (this.buildArgs == null) {
            return (A)((Object)this);
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get((Object)"buildArgs").remove(builder);
            this.buildArgs.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromBuildArgs(Predicate<EnvVarBuilder> predicate) {
        if (this.buildArgs == null) {
            return (A)((Object)this);
        }
        Iterator<EnvVarBuilder> each = this.buildArgs.iterator();
        List visitables = this._visitables.get((Object)"buildArgs");
        while (each.hasNext()) {
            EnvVarBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<EnvVar> buildBuildArgs() {
        return this.buildArgs != null ? DockerBuildStrategyFluent.build(this.buildArgs) : null;
    }

    public EnvVar buildBuildArg(int index) {
        return this.buildArgs.get(index).build();
    }

    public EnvVar buildFirstBuildArg() {
        return this.buildArgs.get(0).build();
    }

    public EnvVar buildLastBuildArg() {
        return this.buildArgs.get(this.buildArgs.size() - 1).build();
    }

    public EnvVar buildMatchingBuildArg(Predicate<EnvVarBuilder> predicate) {
        for (EnvVarBuilder item : this.buildArgs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingBuildArg(Predicate<EnvVarBuilder> predicate) {
        for (EnvVarBuilder item : this.buildArgs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withBuildArgs(List<EnvVar> buildArgs) {
        if (this.buildArgs != null) {
            this._visitables.get((Object)"buildArgs").clear();
        }
        if (buildArgs != null) {
            this.buildArgs = new ArrayList();
            for (EnvVar item : buildArgs) {
                this.addToBuildArgs(item);
            }
        } else {
            this.buildArgs = null;
        }
        return (A)((Object)this);
    }

    public A withBuildArgs(EnvVar ... buildArgs) {
        if (this.buildArgs != null) {
            this.buildArgs.clear();
            this._visitables.remove((Object)"buildArgs");
        }
        if (buildArgs != null) {
            for (EnvVar item : buildArgs) {
                this.addToBuildArgs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasBuildArgs() {
        return this.buildArgs != null && !this.buildArgs.isEmpty();
    }

    public BuildArgsNested<A> addNewBuildArg() {
        return new BuildArgsNested(-1, null);
    }

    public BuildArgsNested<A> addNewBuildArgLike(EnvVar item) {
        return new BuildArgsNested(-1, item);
    }

    public BuildArgsNested<A> setNewBuildArgLike(int index, EnvVar item) {
        return new BuildArgsNested(index, item);
    }

    public BuildArgsNested<A> editBuildArg(int index) {
        if (this.buildArgs.size() <= index) {
            throw new RuntimeException("Can't edit buildArgs. Index exceeds size.");
        }
        return this.setNewBuildArgLike(index, this.buildBuildArg(index));
    }

    public BuildArgsNested<A> editFirstBuildArg() {
        if (this.buildArgs.size() == 0) {
            throw new RuntimeException("Can't edit first buildArgs. The list is empty.");
        }
        return this.setNewBuildArgLike(0, this.buildBuildArg(0));
    }

    public BuildArgsNested<A> editLastBuildArg() {
        int index = this.buildArgs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last buildArgs. The list is empty.");
        }
        return this.setNewBuildArgLike(index, this.buildBuildArg(index));
    }

    public BuildArgsNested<A> editMatchingBuildArg(Predicate<EnvVarBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.buildArgs.size(); ++i) {
            if (!predicate.test(this.buildArgs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching buildArgs. No match found.");
        }
        return this.setNewBuildArgLike(index, this.buildBuildArg(index));
    }

    public String getDockerfilePath() {
        return this.dockerfilePath;
    }

    public A withDockerfilePath(String dockerfilePath) {
        this.dockerfilePath = dockerfilePath;
        return (A)((Object)this);
    }

    public boolean hasDockerfilePath() {
        return this.dockerfilePath != null;
    }

    public A addToEnv(int index, EnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        EnvVarBuilder builder = new EnvVarBuilder(item);
        if (index < 0 || index >= this.env.size()) {
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        } else {
            this._visitables.get((Object)"env").add(index, builder);
            this.env.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToEnv(int index, EnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        EnvVarBuilder builder = new EnvVarBuilder(item);
        if (index < 0 || index >= this.env.size()) {
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        } else {
            this._visitables.get((Object)"env").set(index, builder);
            this.env.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToEnv(EnvVar ... items) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToEnv(Collection<EnvVar> items) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromEnv(EnvVar ... items) {
        if (this.env == null) {
            return (A)((Object)this);
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get((Object)"env").remove(builder);
            this.env.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromEnv(Collection<EnvVar> items) {
        if (this.env == null) {
            return (A)((Object)this);
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get((Object)"env").remove(builder);
            this.env.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromEnv(Predicate<EnvVarBuilder> predicate) {
        if (this.env == null) {
            return (A)((Object)this);
        }
        Iterator<EnvVarBuilder> each = this.env.iterator();
        List visitables = this._visitables.get((Object)"env");
        while (each.hasNext()) {
            EnvVarBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<EnvVar> buildEnv() {
        return this.env != null ? DockerBuildStrategyFluent.build(this.env) : null;
    }

    public EnvVar buildEnv(int index) {
        return this.env.get(index).build();
    }

    public EnvVar buildFirstEnv() {
        return this.env.get(0).build();
    }

    public EnvVar buildLastEnv() {
        return this.env.get(this.env.size() - 1).build();
    }

    public EnvVar buildMatchingEnv(Predicate<EnvVarBuilder> predicate) {
        for (EnvVarBuilder item : this.env) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingEnv(Predicate<EnvVarBuilder> predicate) {
        for (EnvVarBuilder item : this.env) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEnv(List<EnvVar> env) {
        if (this.env != null) {
            this._visitables.get((Object)"env").clear();
        }
        if (env != null) {
            this.env = new ArrayList();
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        } else {
            this.env = null;
        }
        return (A)((Object)this);
    }

    public A withEnv(EnvVar ... env) {
        if (this.env != null) {
            this.env.clear();
            this._visitables.remove((Object)"env");
        }
        if (env != null) {
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasEnv() {
        return this.env != null && !this.env.isEmpty();
    }

    public EnvNested<A> addNewEnv() {
        return new EnvNested(-1, null);
    }

    public EnvNested<A> addNewEnvLike(EnvVar item) {
        return new EnvNested(-1, item);
    }

    public EnvNested<A> setNewEnvLike(int index, EnvVar item) {
        return new EnvNested(index, item);
    }

    public EnvNested<A> editEnv(int index) {
        if (this.env.size() <= index) {
            throw new RuntimeException("Can't edit env. Index exceeds size.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public EnvNested<A> editFirstEnv() {
        if (this.env.size() == 0) {
            throw new RuntimeException("Can't edit first env. The list is empty.");
        }
        return this.setNewEnvLike(0, this.buildEnv(0));
    }

    public EnvNested<A> editLastEnv() {
        int index = this.env.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last env. The list is empty.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public EnvNested<A> editMatchingEnv(Predicate<EnvVarBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.env.size(); ++i) {
            if (!predicate.test(this.env.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching env. No match found.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public Boolean getForcePull() {
        return this.forcePull;
    }

    public A withForcePull(Boolean forcePull) {
        this.forcePull = forcePull;
        return (A)((Object)this);
    }

    public boolean hasForcePull() {
        return this.forcePull != null;
    }

    public ObjectReference buildFrom() {
        return this.from != null ? this.from.build() : null;
    }

    public A withFrom(ObjectReference from) {
        this._visitables.remove((Object)"from");
        if (from != null) {
            this.from = new ObjectReferenceBuilder(from);
            this._visitables.get((Object)"from").add(this.from);
        } else {
            this.from = null;
            this._visitables.get((Object)"from").remove(this.from);
        }
        return (A)((Object)this);
    }

    public boolean hasFrom() {
        return this.from != null;
    }

    public FromNested<A> withNewFrom() {
        return new FromNested(null);
    }

    public FromNested<A> withNewFromLike(ObjectReference item) {
        return new FromNested(item);
    }

    public FromNested<A> editFrom() {
        return this.withNewFromLike(Optional.ofNullable(this.buildFrom()).orElse(null));
    }

    public FromNested<A> editOrNewFrom() {
        return this.withNewFromLike(Optional.ofNullable(this.buildFrom()).orElse(new ObjectReferenceBuilder().build()));
    }

    public FromNested<A> editOrNewFromLike(ObjectReference item) {
        return this.withNewFromLike(Optional.ofNullable(this.buildFrom()).orElse(item));
    }

    public String getImageOptimizationPolicy() {
        return this.imageOptimizationPolicy;
    }

    public A withImageOptimizationPolicy(String imageOptimizationPolicy) {
        this.imageOptimizationPolicy = imageOptimizationPolicy;
        return (A)((Object)this);
    }

    public boolean hasImageOptimizationPolicy() {
        return this.imageOptimizationPolicy != null;
    }

    public Boolean getNoCache() {
        return this.noCache;
    }

    public A withNoCache(Boolean noCache) {
        this.noCache = noCache;
        return (A)((Object)this);
    }

    public boolean hasNoCache() {
        return this.noCache != null;
    }

    public LocalObjectReference buildPullSecret() {
        return this.pullSecret != null ? this.pullSecret.build() : null;
    }

    public A withPullSecret(LocalObjectReference pullSecret) {
        this._visitables.remove((Object)"pullSecret");
        if (pullSecret != null) {
            this.pullSecret = new LocalObjectReferenceBuilder(pullSecret);
            this._visitables.get((Object)"pullSecret").add(this.pullSecret);
        } else {
            this.pullSecret = null;
            this._visitables.get((Object)"pullSecret").remove(this.pullSecret);
        }
        return (A)((Object)this);
    }

    public boolean hasPullSecret() {
        return this.pullSecret != null;
    }

    public A withNewPullSecret(String name) {
        return this.withPullSecret(new LocalObjectReference(name));
    }

    public PullSecretNested<A> withNewPullSecret() {
        return new PullSecretNested(null);
    }

    public PullSecretNested<A> withNewPullSecretLike(LocalObjectReference item) {
        return new PullSecretNested(item);
    }

    public PullSecretNested<A> editPullSecret() {
        return this.withNewPullSecretLike(Optional.ofNullable(this.buildPullSecret()).orElse(null));
    }

    public PullSecretNested<A> editOrNewPullSecret() {
        return this.withNewPullSecretLike(Optional.ofNullable(this.buildPullSecret()).orElse(new LocalObjectReferenceBuilder().build()));
    }

    public PullSecretNested<A> editOrNewPullSecretLike(LocalObjectReference item) {
        return this.withNewPullSecretLike(Optional.ofNullable(this.buildPullSecret()).orElse(item));
    }

    public A addToVolumes(int index, BuildVolume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        BuildVolumeBuilder builder = new BuildVolumeBuilder(item);
        if (index < 0 || index >= this.volumes.size()) {
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        } else {
            this._visitables.get((Object)"volumes").add(index, builder);
            this.volumes.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToVolumes(int index, BuildVolume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        BuildVolumeBuilder builder = new BuildVolumeBuilder(item);
        if (index < 0 || index >= this.volumes.size()) {
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        } else {
            this._visitables.get((Object)"volumes").set(index, builder);
            this.volumes.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToVolumes(BuildVolume ... items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        for (BuildVolume item : items) {
            BuildVolumeBuilder builder = new BuildVolumeBuilder(item);
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToVolumes(Collection<BuildVolume> items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        for (BuildVolume item : items) {
            BuildVolumeBuilder builder = new BuildVolumeBuilder(item);
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromVolumes(BuildVolume ... items) {
        if (this.volumes == null) {
            return (A)((Object)this);
        }
        for (BuildVolume item : items) {
            BuildVolumeBuilder builder = new BuildVolumeBuilder(item);
            this._visitables.get((Object)"volumes").remove((Object)builder);
            this.volumes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromVolumes(Collection<BuildVolume> items) {
        if (this.volumes == null) {
            return (A)((Object)this);
        }
        for (BuildVolume item : items) {
            BuildVolumeBuilder builder = new BuildVolumeBuilder(item);
            this._visitables.get((Object)"volumes").remove((Object)builder);
            this.volumes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromVolumes(Predicate<BuildVolumeBuilder> predicate) {
        if (this.volumes == null) {
            return (A)((Object)this);
        }
        Iterator<BuildVolumeBuilder> each = this.volumes.iterator();
        List visitables = this._visitables.get((Object)"volumes");
        while (each.hasNext()) {
            BuildVolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<BuildVolume> buildVolumes() {
        return this.volumes != null ? DockerBuildStrategyFluent.build(this.volumes) : null;
    }

    public BuildVolume buildVolume(int index) {
        return this.volumes.get(index).build();
    }

    public BuildVolume buildFirstVolume() {
        return this.volumes.get(0).build();
    }

    public BuildVolume buildLastVolume() {
        return this.volumes.get(this.volumes.size() - 1).build();
    }

    public BuildVolume buildMatchingVolume(Predicate<BuildVolumeBuilder> predicate) {
        for (BuildVolumeBuilder item : this.volumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingVolume(Predicate<BuildVolumeBuilder> predicate) {
        for (BuildVolumeBuilder item : this.volumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withVolumes(List<BuildVolume> volumes) {
        if (this.volumes != null) {
            this._visitables.get((Object)"volumes").clear();
        }
        if (volumes != null) {
            this.volumes = new ArrayList();
            for (BuildVolume item : volumes) {
                this.addToVolumes(item);
            }
        } else {
            this.volumes = null;
        }
        return (A)((Object)this);
    }

    public A withVolumes(BuildVolume ... volumes) {
        if (this.volumes != null) {
            this.volumes.clear();
            this._visitables.remove((Object)"volumes");
        }
        if (volumes != null) {
            for (BuildVolume item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasVolumes() {
        return this.volumes != null && !this.volumes.isEmpty();
    }

    public VolumesNested<A> addNewVolume() {
        return new VolumesNested(-1, null);
    }

    public VolumesNested<A> addNewVolumeLike(BuildVolume item) {
        return new VolumesNested(-1, item);
    }

    public VolumesNested<A> setNewVolumeLike(int index, BuildVolume item) {
        return new VolumesNested(index, item);
    }

    public VolumesNested<A> editVolume(int index) {
        if (this.volumes.size() <= index) {
            throw new RuntimeException("Can't edit volumes. Index exceeds size.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    public VolumesNested<A> editFirstVolume() {
        if (this.volumes.size() == 0) {
            throw new RuntimeException("Can't edit first volumes. The list is empty.");
        }
        return this.setNewVolumeLike(0, this.buildVolume(0));
    }

    public VolumesNested<A> editLastVolume() {
        int index = this.volumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last volumes. The list is empty.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    public VolumesNested<A> editMatchingVolume(Predicate<BuildVolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumes.size(); ++i) {
            if (!predicate.test(this.volumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching volumes. No match found.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DockerBuildStrategyFluent that = (DockerBuildStrategyFluent)((Object)o);
        if (!Objects.equals(this.buildArgs, that.buildArgs)) {
            return false;
        }
        if (!Objects.equals(this.dockerfilePath, that.dockerfilePath)) {
            return false;
        }
        if (!Objects.equals(this.env, that.env)) {
            return false;
        }
        if (!Objects.equals(this.forcePull, that.forcePull)) {
            return false;
        }
        if (!Objects.equals(this.from, that.from)) {
            return false;
        }
        if (!Objects.equals(this.imageOptimizationPolicy, that.imageOptimizationPolicy)) {
            return false;
        }
        if (!Objects.equals(this.noCache, that.noCache)) {
            return false;
        }
        if (!Objects.equals(this.pullSecret, that.pullSecret)) {
            return false;
        }
        if (!Objects.equals(this.volumes, that.volumes)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.buildArgs, this.dockerfilePath, this.env, this.forcePull, this.from, this.imageOptimizationPolicy, this.noCache, this.pullSecret, this.volumes, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.buildArgs != null && !this.buildArgs.isEmpty()) {
            sb.append("buildArgs:");
            sb.append(this.buildArgs + ",");
        }
        if (this.dockerfilePath != null) {
            sb.append("dockerfilePath:");
            sb.append(this.dockerfilePath + ",");
        }
        if (this.env != null && !this.env.isEmpty()) {
            sb.append("env:");
            sb.append(this.env + ",");
        }
        if (this.forcePull != null) {
            sb.append("forcePull:");
            sb.append(this.forcePull + ",");
        }
        if (this.from != null) {
            sb.append("from:");
            sb.append(this.from + ",");
        }
        if (this.imageOptimizationPolicy != null) {
            sb.append("imageOptimizationPolicy:");
            sb.append(this.imageOptimizationPolicy + ",");
        }
        if (this.noCache != null) {
            sb.append("noCache:");
            sb.append(this.noCache + ",");
        }
        if (this.pullSecret != null) {
            sb.append("pullSecret:");
            sb.append(this.pullSecret + ",");
        }
        if (this.volumes != null && !this.volumes.isEmpty()) {
            sb.append("volumes:");
            sb.append(this.volumes + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withForcePull() {
        return this.withForcePull(true);
    }

    public A withNoCache() {
        return this.withNoCache(true);
    }

    public class VolumesNested<N>
    extends BuildVolumeFluent<VolumesNested<N>>
    implements Nested<N> {
        BuildVolumeBuilder builder;
        int index;

        VolumesNested(int index, BuildVolume item) {
            this.index = index;
            this.builder = new BuildVolumeBuilder(this, item);
        }

        public N and() {
            return (N)DockerBuildStrategyFluent.this.setToVolumes(this.index, this.builder.build());
        }

        public N endVolume() {
            return this.and();
        }
    }

    public class PullSecretNested<N>
    extends LocalObjectReferenceFluent<PullSecretNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;

        PullSecretNested(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder((LocalObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)DockerBuildStrategyFluent.this.withPullSecret(this.builder.build());
        }

        public N endPullSecret() {
            return this.and();
        }
    }

    public class FromNested<N>
    extends ObjectReferenceFluent<FromNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        FromNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)DockerBuildStrategyFluent.this.withFrom(this.builder.build());
        }

        public N endFrom() {
            return this.and();
        }
    }

    public class EnvNested<N>
    extends EnvVarFluent<EnvNested<N>>
    implements Nested<N> {
        EnvVarBuilder builder;
        int index;

        EnvNested(int index, EnvVar item) {
            this.index = index;
            this.builder = new EnvVarBuilder((EnvVarFluent)this, item);
        }

        public N and() {
            return (N)DockerBuildStrategyFluent.this.setToEnv(this.index, this.builder.build());
        }

        public N endEnv() {
            return this.and();
        }
    }

    public class BuildArgsNested<N>
    extends EnvVarFluent<BuildArgsNested<N>>
    implements Nested<N> {
        EnvVarBuilder builder;
        int index;

        BuildArgsNested(int index, EnvVar item) {
            this.index = index;
            this.builder = new EnvVarBuilder((EnvVarFluent)this, item);
        }

        public N and() {
            return (N)DockerBuildStrategyFluent.this.setToBuildArgs(this.index, this.builder.build());
        }

        public N endBuildArg() {
            return this.and();
        }
    }
}

