/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.servicecatalog.examples;

import io.fabric8.servicecatalog.api.model.ClusterServiceClassList;
import io.fabric8.servicecatalog.client.ServiceCatalogClient;
import io.fabric8.servicecatalog.client.dsl.ClusterServiceBrokerResource;
import io.fabric8.servicecatalog.examples.ClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListServiceClassesByBroker {
    private static final Logger logger = LoggerFactory.getLogger((String)ListServiceClassesByBroker.class.getSimpleName());

    public static void main(String[] args) {
        ServiceCatalogClient client = ClientFactory.newClient(args);
        String broker = ClientFactory.getOptions(args, "--broker", null);
        if (broker == null || broker.isEmpty()) {
            logger.info("Missing --broker option!");
            System.exit(1);
        }
        logger.info("Listing Cluster Service Classes {} :", (Object)broker);
        ClusterServiceClassList list = ((ClusterServiceBrokerResource)client.clusterServiceBrokers().withName(broker)).listClasses();
        list.getItems().forEach(b -> logger.info(b.getSpec().getExternalName() + "\t\t\t\t" + b.getMetadata().getName()));
        logger.info("Done");
    }
}

