/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.servicecatalog.client.internal;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.base.BaseOperation;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.servicecatalog.api.model.ClusterServiceBroker;
import io.fabric8.servicecatalog.api.model.ClusterServiceBrokerList;
import io.fabric8.servicecatalog.api.model.ClusterServiceClass;
import io.fabric8.servicecatalog.api.model.ClusterServiceClassList;
import io.fabric8.servicecatalog.api.model.ClusterServicePlanList;
import io.fabric8.servicecatalog.client.internal.ClusterServiceBrokerResource;
import io.fabric8.servicecatalog.client.internal.ClusterServiceClassOperationsImpl;
import io.fabric8.servicecatalog.client.internal.ClusterServiceClassResource;
import io.fabric8.servicecatalog.client.internal.ClusterServicePlanOperationsImpl;
import java.util.HashMap;
import java.util.List;
import okhttp3.OkHttpClient;

public class ClusterServiceBrokerOperationsImpl
extends HasMetadataOperation<ClusterServiceBroker, ClusterServiceBrokerList, ClusterServiceBrokerResource>
implements ClusterServiceBrokerResource {
    public ClusterServiceBrokerOperationsImpl(OkHttpClient client, Config config) {
        this(new OperationContext().withOkhttpClient(client).withConfig(config));
    }

    public ClusterServiceBrokerOperationsImpl(OperationContext context) {
        super(context.withApiGroupName("servicecatalog.k8s.io").withApiGroupVersion("v1beta1").withPlural("clusterservicebrokers"), ClusterServiceBroker.class, ClusterServiceBrokerList.class);
    }

    public BaseOperation<ClusterServiceBroker, ClusterServiceBrokerList, ClusterServiceBrokerResource> newInstance(OperationContext context) {
        return new ClusterServiceBrokerOperationsImpl(context);
    }

    public boolean isResourceNamespaced() {
        return false;
    }

    @Override
    public ClusterServicePlanList listPlans() {
        ClusterServiceBroker item = (ClusterServiceBroker)this.get();
        return (ClusterServicePlanList)new ClusterServicePlanOperationsImpl(this.context).withField("spec.clusterServiceBrokerName", item.getMetadata().getName()).list();
    }

    @Override
    public ClusterServiceClassList listClasses() {
        ClusterServiceBroker item = (ClusterServiceBroker)this.get();
        return (ClusterServiceClassList)new ClusterServiceClassOperationsImpl(this.context).withField("spec.clusterServiceBrokerName", item.getMetadata().getName()).list();
    }

    @Override
    public ClusterServiceClassResource useServiceClass(String externalName) {
        ClusterServiceBroker item = (ClusterServiceBroker)this.get();
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("spec.clusterServiceBrokerName", item.getMetadata().getName());
        fields.put("spec.externalName", externalName);
        List list = ((ClusterServiceClassList)new ClusterServiceClassOperationsImpl(this.context.withFields(fields)).list()).getItems();
        if (list.size() != 1) {
            throw new IllegalArgumentException("No unique ClusterServiceClass with external name:" + externalName + "found for ClusterServiceBroker: " + item.getMetadata().getName());
        }
        ClusterServiceClass c = (ClusterServiceClass)list.get(0);
        return new ClusterServiceClassOperationsImpl(this.context);
    }
}

