/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.servicecatalog.client;

import io.fabric8.kubernetes.client.BaseClient;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.ClientContext;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.Handlers;
import io.fabric8.kubernetes.client.RequestConfig;
import io.fabric8.kubernetes.client.WithRequestCallable;
import io.fabric8.kubernetes.client.dsl.FunctionCallable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.servicecatalog.api.model.ClusterServiceBroker;
import io.fabric8.servicecatalog.api.model.ClusterServiceBrokerList;
import io.fabric8.servicecatalog.api.model.ClusterServiceClass;
import io.fabric8.servicecatalog.api.model.ClusterServiceClassList;
import io.fabric8.servicecatalog.api.model.ClusterServicePlan;
import io.fabric8.servicecatalog.api.model.ClusterServicePlanList;
import io.fabric8.servicecatalog.api.model.ServiceBinding;
import io.fabric8.servicecatalog.api.model.ServiceBindingList;
import io.fabric8.servicecatalog.api.model.ServiceBroker;
import io.fabric8.servicecatalog.api.model.ServiceBrokerList;
import io.fabric8.servicecatalog.api.model.ServiceClass;
import io.fabric8.servicecatalog.api.model.ServiceClassList;
import io.fabric8.servicecatalog.api.model.ServiceInstance;
import io.fabric8.servicecatalog.api.model.ServiceInstanceList;
import io.fabric8.servicecatalog.api.model.ServicePlan;
import io.fabric8.servicecatalog.api.model.ServicePlanList;
import io.fabric8.servicecatalog.client.NamespacedServiceCatalogClient;
import io.fabric8.servicecatalog.client.internal.ClusterServiceBrokerOperationsImpl;
import io.fabric8.servicecatalog.client.internal.ClusterServiceBrokerResource;
import io.fabric8.servicecatalog.client.internal.ClusterServiceClassOperationsImpl;
import io.fabric8.servicecatalog.client.internal.ClusterServiceClassResource;
import io.fabric8.servicecatalog.client.internal.ClusterServicePlanOperationsImpl;
import io.fabric8.servicecatalog.client.internal.ClusterServicePlanResource;
import io.fabric8.servicecatalog.client.internal.ServiceBindingOperationsImpl;
import io.fabric8.servicecatalog.client.internal.ServiceBindingResource;
import io.fabric8.servicecatalog.client.internal.ServiceInstanceOperationsImpl;
import io.fabric8.servicecatalog.client.internal.ServiceInstanceResource;

public class DefaultServiceCatalogClient
extends BaseClient
implements NamespacedServiceCatalogClient {
    public DefaultServiceCatalogClient() {
    }

    public DefaultServiceCatalogClient(Config configuration) {
        super(configuration);
    }

    public DefaultServiceCatalogClient(ClientContext clientContext) {
        super(clientContext);
    }

    @Override
    public NonNamespaceOperation<ClusterServiceBroker, ClusterServiceBrokerList, ClusterServiceBrokerResource> clusterServiceBrokers() {
        return new ClusterServiceBrokerOperationsImpl((ClientContext)this);
    }

    @Override
    public NonNamespaceOperation<ClusterServiceClass, ClusterServiceClassList, ClusterServiceClassResource> clusterServiceClasses() {
        return new ClusterServiceClassOperationsImpl((ClientContext)this);
    }

    @Override
    public NonNamespaceOperation<ClusterServicePlan, ClusterServicePlanList, ClusterServicePlanResource> clusterServicePlans() {
        return new ClusterServicePlanOperationsImpl((ClientContext)this);
    }

    @Override
    public MixedOperation<ServiceInstance, ServiceInstanceList, ServiceInstanceResource> serviceInstances() {
        return new ServiceInstanceOperationsImpl((ClientContext)this);
    }

    @Override
    public MixedOperation<ServiceBinding, ServiceBindingList, ServiceBindingResource> serviceBindings() {
        return new ServiceBindingOperationsImpl((ClientContext)this);
    }

    @Override
    public MixedOperation<ServiceBroker, ServiceBrokerList, Resource<ServiceBroker>> serviceBrokers() {
        return Handlers.getOperation(ServiceBroker.class, ServiceBrokerList.class, (ClientContext)this);
    }

    @Override
    public MixedOperation<ServiceClass, ServiceClassList, Resource<ServiceClass>> serviceClasses() {
        return Handlers.getOperation(ServiceClass.class, ServiceClassList.class, (ClientContext)this);
    }

    @Override
    public MixedOperation<ServicePlan, ServicePlanList, Resource<ServicePlan>> servicePlans() {
        return Handlers.getOperation(ServicePlan.class, ServicePlanList.class, (ClientContext)this);
    }

    public NamespacedServiceCatalogClient inAnyNamespace() {
        return this.inNamespace(null);
    }

    public NamespacedServiceCatalogClient inNamespace(String namespace) {
        Config updated = ((ConfigBuilder)new ConfigBuilder(this.getConfiguration()).withNamespace(namespace)).build();
        return new DefaultServiceCatalogClient((ClientContext)this.newState(updated));
    }

    public FunctionCallable<NamespacedServiceCatalogClient> withRequestConfig(RequestConfig requestConfig) {
        return new WithRequestCallable((Client)this, requestConfig);
    }
}

