package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class SecretTransformBuilder extends SecretTransformFluent<SecretTransformBuilder> implements VisitableBuilder<SecretTransform,SecretTransformBuilder>{
  public SecretTransformBuilder() {
    this(new SecretTransform());
  }
  
  public SecretTransformBuilder(SecretTransformFluent<?> fluent) {
    this(fluent, new SecretTransform());
  }
  
  public SecretTransformBuilder(SecretTransformFluent<?> fluent,SecretTransform instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public SecretTransformBuilder(SecretTransform instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  SecretTransformFluent<?> fluent;
  
  public SecretTransform build() {
    SecretTransform buildable = new SecretTransform(fluent.buildAddKey(),fluent.buildAddKeysFrom(),fluent.buildRemoveKey(),fluent.buildRenameKey());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}