package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ServicePlanSpecBuilder extends ServicePlanSpecFluent<ServicePlanSpecBuilder> implements VisitableBuilder<ServicePlanSpec,ServicePlanSpecBuilder>{
  public ServicePlanSpecBuilder() {
    this(new ServicePlanSpec());
  }
  
  public ServicePlanSpecBuilder(ServicePlanSpecFluent<?> fluent) {
    this(fluent, new ServicePlanSpec());
  }
  
  public ServicePlanSpecBuilder(ServicePlanSpecFluent<?> fluent,ServicePlanSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ServicePlanSpecBuilder(ServicePlanSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ServicePlanSpecFluent<?> fluent;
  
  public ServicePlanSpec build() {
    ServicePlanSpec buildable = new ServicePlanSpec(fluent.getBindable(),fluent.getDefaultProvisionParameters(),fluent.getDescription(),fluent.getExternalID(),fluent.getExternalMetadata(),fluent.getExternalName(),fluent.getFree(),fluent.getInstanceCreateParameterSchema(),fluent.getInstanceUpdateParameterSchema(),fluent.getServiceBindingCreateParameterSchema(),fluent.getServiceBindingCreateResponseSchema(),fluent.getServiceBrokerName(),fluent.buildServiceClassRef());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}