/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.tekton.triggers.v1alpha1.KubernetesResource;
import io.fabric8.tekton.triggers.v1alpha1.KubernetesResourceFluent;
import io.fabric8.tekton.triggers.v1alpha1.KubernetesResourceFluentImpl;
import java.util.Objects;

public class KubernetesResourceBuilder
extends KubernetesResourceFluentImpl<KubernetesResourceBuilder>
implements VisitableBuilder<KubernetesResource, KubernetesResourceBuilder> {
    KubernetesResourceFluent<?> fluent;
    Boolean validationEnabled;

    public KubernetesResourceBuilder() {
        this(false);
    }

    public KubernetesResourceBuilder(Boolean validationEnabled) {
        this(new KubernetesResource(), validationEnabled);
    }

    public KubernetesResourceBuilder(KubernetesResourceFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public KubernetesResourceBuilder(KubernetesResourceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new KubernetesResource(), validationEnabled);
    }

    public KubernetesResourceBuilder(KubernetesResourceFluent<?> fluent, KubernetesResource instance) {
        this(fluent, instance, false);
    }

    public KubernetesResourceBuilder(KubernetesResourceFluent<?> fluent, KubernetesResource instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withReplicas(instance.getReplicas());
        fluent.withServiceType(instance.getServiceType());
        fluent.withSpec(instance.getSpec());
        this.validationEnabled = validationEnabled;
    }

    public KubernetesResourceBuilder(KubernetesResource instance) {
        this(instance, (Boolean)false);
    }

    public KubernetesResourceBuilder(KubernetesResource instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withReplicas(instance.getReplicas());
        this.withServiceType(instance.getServiceType());
        this.withSpec(instance.getSpec());
        this.validationEnabled = validationEnabled;
    }

    public KubernetesResource build() {
        KubernetesResource buildable = new KubernetesResource(this.fluent.getReplicas(), this.fluent.getServiceType(), this.fluent.getSpec());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KubernetesResourceBuilder that = (KubernetesResourceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

