/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.verticalpodautoscaler.api.model.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.verticalpodautoscaler.api.model.v1.ContainerResourcePolicy;
import io.fabric8.verticalpodautoscaler.api.model.v1.ContainerResourcePolicyFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ContainerResourcePolicyFluentImpl<A extends ContainerResourcePolicyFluent<A>>
extends BaseFluent<A>
implements ContainerResourcePolicyFluent<A> {
    private String containerName;
    private List<String> controlledResources;
    private String controlledValues;
    private Map<String, Quantity> maxAllowed;
    private Map<String, Quantity> minAllowed;
    private String mode;

    public ContainerResourcePolicyFluentImpl() {
    }

    public ContainerResourcePolicyFluentImpl(ContainerResourcePolicy instance) {
        this.withContainerName(instance.getContainerName());
        this.withControlledResources(instance.getControlledResources());
        this.withControlledValues(instance.getControlledValues());
        this.withMaxAllowed(instance.getMaxAllowed());
        this.withMinAllowed(instance.getMinAllowed());
        this.withMode(instance.getMode());
    }

    @Override
    public String getContainerName() {
        return this.containerName;
    }

    @Override
    public A withContainerName(String containerName) {
        this.containerName = containerName;
        return (A)this;
    }

    @Override
    public Boolean hasContainerName() {
        return this.containerName != null;
    }

    @Override
    @Deprecated
    public A withNewContainerName(String arg0) {
        return this.withContainerName(new String(arg0));
    }

    @Override
    public A addToControlledResources(Integer index, String item) {
        if (this.controlledResources == null) {
            this.controlledResources = new ArrayList<String>();
        }
        this.controlledResources.add(index, item);
        return (A)this;
    }

    @Override
    public A setToControlledResources(Integer index, String item) {
        if (this.controlledResources == null) {
            this.controlledResources = new ArrayList<String>();
        }
        this.controlledResources.set(index, item);
        return (A)this;
    }

    @Override
    public A addToControlledResources(String ... items) {
        if (this.controlledResources == null) {
            this.controlledResources = new ArrayList<String>();
        }
        for (String item : items) {
            this.controlledResources.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToControlledResources(Collection<String> items) {
        if (this.controlledResources == null) {
            this.controlledResources = new ArrayList<String>();
        }
        for (String item : items) {
            this.controlledResources.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromControlledResources(String ... items) {
        for (String item : items) {
            if (this.controlledResources == null) continue;
            this.controlledResources.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromControlledResources(Collection<String> items) {
        for (String item : items) {
            if (this.controlledResources == null) continue;
            this.controlledResources.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getControlledResources() {
        return this.controlledResources;
    }

    @Override
    public String getControlledResource(Integer index) {
        return this.controlledResources.get(index);
    }

    @Override
    public String getFirstControlledResource() {
        return this.controlledResources.get(0);
    }

    @Override
    public String getLastControlledResource() {
        return this.controlledResources.get(this.controlledResources.size() - 1);
    }

    @Override
    public String getMatchingControlledResource(Predicate<String> predicate) {
        for (String item : this.controlledResources) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingControlledResource(Predicate<String> predicate) {
        for (String item : this.controlledResources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withControlledResources(List<String> controlledResources) {
        if (controlledResources != null) {
            this.controlledResources = new ArrayList<String>();
            for (String item : controlledResources) {
                this.addToControlledResources(item);
            }
        } else {
            this.controlledResources = null;
        }
        return (A)this;
    }

    @Override
    public A withControlledResources(String ... controlledResources) {
        if (this.controlledResources != null) {
            this.controlledResources.clear();
        }
        if (controlledResources != null) {
            for (String item : controlledResources) {
                this.addToControlledResources(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasControlledResources() {
        return this.controlledResources != null && !this.controlledResources.isEmpty();
    }

    @Override
    public A addNewControlledResource(String arg0) {
        return this.addToControlledResources(new String(arg0));
    }

    @Override
    public String getControlledValues() {
        return this.controlledValues;
    }

    @Override
    public A withControlledValues(String controlledValues) {
        this.controlledValues = controlledValues;
        return (A)this;
    }

    @Override
    public Boolean hasControlledValues() {
        return this.controlledValues != null;
    }

    @Override
    @Deprecated
    public A withNewControlledValues(String arg0) {
        return this.withControlledValues(new String(arg0));
    }

    @Override
    public A addToMaxAllowed(String key, Quantity value) {
        if (this.maxAllowed == null && key != null && value != null) {
            this.maxAllowed = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.maxAllowed.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToMaxAllowed(Map<String, Quantity> map) {
        if (this.maxAllowed == null && map != null) {
            this.maxAllowed = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.maxAllowed.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromMaxAllowed(String key) {
        if (this.maxAllowed == null) {
            return (A)this;
        }
        if (key != null && this.maxAllowed != null) {
            this.maxAllowed.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromMaxAllowed(Map<String, Quantity> map) {
        if (this.maxAllowed == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.maxAllowed == null) continue;
                this.maxAllowed.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Quantity> getMaxAllowed() {
        return this.maxAllowed;
    }

    @Override
    public <K, V> A withMaxAllowed(Map<String, Quantity> maxAllowed) {
        this.maxAllowed = maxAllowed == null ? null : new LinkedHashMap<String, Quantity>(maxAllowed);
        return (A)this;
    }

    @Override
    public Boolean hasMaxAllowed() {
        return this.maxAllowed != null;
    }

    @Override
    public A addToMinAllowed(String key, Quantity value) {
        if (this.minAllowed == null && key != null && value != null) {
            this.minAllowed = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.minAllowed.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToMinAllowed(Map<String, Quantity> map) {
        if (this.minAllowed == null && map != null) {
            this.minAllowed = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.minAllowed.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromMinAllowed(String key) {
        if (this.minAllowed == null) {
            return (A)this;
        }
        if (key != null && this.minAllowed != null) {
            this.minAllowed.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromMinAllowed(Map<String, Quantity> map) {
        if (this.minAllowed == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.minAllowed == null) continue;
                this.minAllowed.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Quantity> getMinAllowed() {
        return this.minAllowed;
    }

    @Override
    public <K, V> A withMinAllowed(Map<String, Quantity> minAllowed) {
        this.minAllowed = minAllowed == null ? null : new LinkedHashMap<String, Quantity>(minAllowed);
        return (A)this;
    }

    @Override
    public Boolean hasMinAllowed() {
        return this.minAllowed != null;
    }

    @Override
    public String getMode() {
        return this.mode;
    }

    @Override
    public A withMode(String mode) {
        this.mode = mode;
        return (A)this;
    }

    @Override
    public Boolean hasMode() {
        return this.mode != null;
    }

    @Override
    @Deprecated
    public A withNewMode(String arg0) {
        return this.withMode(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerResourcePolicyFluentImpl that = (ContainerResourcePolicyFluentImpl)o;
        if (this.containerName != null ? !this.containerName.equals(that.containerName) : that.containerName != null) {
            return false;
        }
        if (this.controlledResources != null ? !this.controlledResources.equals(that.controlledResources) : that.controlledResources != null) {
            return false;
        }
        if (this.controlledValues != null ? !this.controlledValues.equals(that.controlledValues) : that.controlledValues != null) {
            return false;
        }
        if (this.maxAllowed != null ? !this.maxAllowed.equals(that.maxAllowed) : that.maxAllowed != null) {
            return false;
        }
        if (this.minAllowed != null ? !this.minAllowed.equals(that.minAllowed) : that.minAllowed != null) {
            return false;
        }
        return !(this.mode != null ? !this.mode.equals(that.mode) : that.mode != null);
    }

    public int hashCode() {
        return Objects.hash(this.containerName, this.controlledResources, this.controlledValues, this.maxAllowed, this.minAllowed, this.mode, super.hashCode());
    }
}

