/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.vertx.maven.plugin.mojos;

import com.google.common.base.Strings;
import io.fabric8.vertx.maven.plugin.components.Prompter;
import io.fabric8.vertx.maven.plugin.dependencies.VertxDependencies;
import io.fabric8.vertx.maven.plugin.dependencies.VertxDependency;
import io.fabric8.vertx.maven.plugin.utils.MojoUtils;
import io.fabric8.vertx.maven.plugin.utils.SetupTemplateUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="setup", requiresProject=false)
public class SetupMojo
extends AbstractMojo {
    final String PLUGIN_GROUPID = "io.fabric8";
    final String PLUGIN_ARTIFACTID = "vertx-maven-plugin";
    final String VERTX_MAVEN_PLUGIN_VERSION_PROPERTY = "vertx-maven-plugin-version";
    @Parameter(defaultValue="${project}")
    protected MavenProject project;
    @Parameter(property="projectGroupId")
    protected String projectGroupId;
    @Parameter(property="projectArtifactId")
    protected String projectArtifactId;
    @Parameter(property="projectVersion", defaultValue="1.0-SNAPSHOT")
    protected String projectVersion;
    @Parameter(property="vertxVersion")
    protected String vertxVersion;
    @Parameter(property="verticle")
    protected String verticle;
    @Parameter(property="dependencies")
    protected List<String> dependencies;
    @Component
    protected Prompter prompter;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Model model;
        File pomFile = this.project.getFile();
        if (pomFile == null || !pomFile.isFile()) {
            String workingdDir = System.getProperty("user.dir");
            this.getLog().info((CharSequence)("No pom.xml found, creating it in " + workingdDir));
            pomFile = new File(workingdDir, "pom.xml");
            try {
                if (this.projectGroupId == null) {
                    this.projectGroupId = this.prompter.promptWithDefaultValue("Set the project groupId", "io.vertx.example");
                }
                if (this.projectArtifactId == null) {
                    this.projectArtifactId = this.prompter.promptWithDefaultValue("Set the project artifactId", "my-vertx-project");
                    this.projectVersion = this.prompter.promptWithDefaultValue("Set the project version", "1.0-SNAPSHOT");
                    if (this.vertxVersion == null) {
                        this.vertxVersion = this.prompter.promptWithDefaultValue("Set the Vert.x version", MojoUtils.getVersion("vertx-core-version"));
                    }
                    if (this.verticle == null) {
                        this.verticle = this.prompter.promptWithDefaultValue("Set the vertcile class name", this.projectGroupId + ".MainVerticle");
                    }
                }
                if (this.verticle != null && this.verticle.endsWith(".java")) {
                    this.verticle = this.verticle.substring(0, this.verticle.length() - ".java".length());
                }
                HashMap<String, String> context = new HashMap<String, String>();
                context.put("mProjectGroupId", this.projectGroupId);
                context.put("mProjectArtifactId", this.projectArtifactId);
                context.put("mProjectVersion", this.projectVersion);
                context.put("vertxVersion", this.vertxVersion != null ? this.vertxVersion : MojoUtils.getVersion("vertx-core-version"));
                context.put("vertxVerticle", this.verticle);
                context.put("fabric8VMPVersion", MojoUtils.getVersion("vertx-maven-plugin-version"));
                SetupTemplateUtils.createPom(context, pomFile);
                MavenXpp3Reader xpp3Reader = new MavenXpp3Reader();
                model = xpp3Reader.read((InputStream)new FileInputStream(pomFile));
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error while setup of vertx-maven-plugin", e);
            }
            this.project = new MavenProject(model);
            this.project.setPomFile(pomFile);
            this.project.setOriginalModel(model);
            if (this.addDependencies(model)) {
                this.save(pomFile, model);
            }
        }
        model = this.project.getOriginalModel().clone();
        this.createDirectories();
        SetupTemplateUtils.createVerticle(this.project, this.verticle, this.getLog());
        Optional<Plugin> vmPlugin = MojoUtils.hasPlugin(this.project, "io.fabric8:vertx-maven-plugin");
        if (!vmPlugin.isPresent()) {
            model.getProperties().putIfAbsent("fabric8-vertx-maven-plugin.projectVersion", MojoUtils.getVersion("vertx-maven-plugin-version"));
            this.vertxVersion = this.vertxVersion == null ? MojoUtils.getVersion("vertx-core-version") : this.vertxVersion;
            model.getProperties().putIfAbsent("vertx.projectVersion", this.vertxVersion);
            if (!Strings.isNullOrEmpty((String)this.verticle)) {
                if (this.verticle.endsWith(".java")) {
                    this.verticle = this.verticle.substring(0, this.verticle.length() - ".java".length());
                }
                model.getProperties().putIfAbsent("vertx.verticle", this.verticle);
            }
            this.addVertxBom(model);
            this.addVertxDependencies(model);
            this.addDependencies(model);
            Plugin vertxMavenPlugin = MojoExecutor.plugin((String)"io.fabric8", (String)"vertx-maven-plugin", (String)"${fabric8-vertx-maven-plugin.projectVersion}");
            if (this.isParentPom(model)) {
                if (model.getBuild().getPluginManagement() != null) {
                    if (model.getBuild().getPluginManagement().getPlugins() == null) {
                        model.getBuild().getPluginManagement().setPlugins(new ArrayList());
                    }
                    model.getBuild().getPluginManagement().getPlugins().add(vertxMavenPlugin);
                }
                vertxMavenPlugin = MojoExecutor.plugin((String)"io.fabric8", (String)"vertx-maven-plugin");
            } else {
                vertxMavenPlugin = MojoExecutor.plugin((String)"io.fabric8", (String)"vertx-maven-plugin", (String)"${fabric8-vertx-maven-plugin.projectVersion}");
            }
            PluginExecution pluginExec = new PluginExecution();
            pluginExec.addGoal("initialize");
            pluginExec.addGoal("package");
            pluginExec.setId("vmp-init-package");
            vertxMavenPlugin.addExecution(pluginExec);
            vertxMavenPlugin.setConfiguration((Object)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"redeploy", (String)"true")}));
            Build build = model.getBuild();
            if (build == null) {
                build = new Build();
                model.setBuild(build);
            }
            if (build.getPlugins() == null) {
                build.setPlugins(new ArrayList());
            }
            build.getPlugins().add(vertxMavenPlugin);
            this.save(pomFile, model);
        }
    }

    private void save(File pomFile, Model model) throws MojoExecutionException {
        MavenXpp3Writer xpp3Writer = new MavenXpp3Writer();
        FileWriter pomFileWriter = null;
        try {
            pomFileWriter = new FileWriter(pomFile);
            xpp3Writer.write((Writer)pomFileWriter, model);
            pomFileWriter.flush();
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Unable to write the pom.xml file", (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(pomFileWriter);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)pomFileWriter);
    }

    private boolean addDependencies(Model model) {
        if (this.dependencies == null || this.dependencies.isEmpty()) {
            return false;
        }
        boolean updated = false;
        List<VertxDependency> deps = VertxDependencies.get();
        for (String dependency : this.dependencies) {
            Optional<VertxDependency> optional = deps.stream().filter(d -> d.labels().contains(dependency.toLowerCase())).findAny();
            if (optional.isPresent()) {
                this.getLog().info((CharSequence)("Adding dependency " + optional.get().toCoordinates()));
                model.addDependency(optional.get().toDependency());
                updated = true;
                continue;
            }
            if (dependency.contains(":")) {
                String[] segments = dependency.split(":");
                if (segments.length >= 2) {
                    Dependency d2 = new Dependency();
                    d2.setGroupId(segments[0]);
                    d2.setArtifactId(segments[1]);
                    if (segments.length >= 3 && !segments[2].isEmpty()) {
                        d2.setVersion(segments[2]);
                    }
                    if (segments.length >= 4) {
                        d2.setClassifier(segments[3]);
                    }
                    this.getLog().info((CharSequence)("Adding dependency " + d2.getManagementKey()));
                    model.addDependency(d2);
                    updated = true;
                    continue;
                }
                this.getLog().warn((CharSequence)("Invalid dependency description '" + dependency + "'"));
                continue;
            }
            this.getLog().warn((CharSequence)("Cannot find a dependency matching '" + dependency + "'"));
        }
        return updated;
    }

    private void createDirectories() {
        boolean res;
        File root = this.project.getBasedir();
        File source = new File(root, "src/main/java");
        File resources = new File(root, "src/main/resources");
        File test = new File(root, "src/test/java");
        if (!source.isDirectory()) {
            res = source.mkdirs();
            this.getLog().debug((CharSequence)("Creation of " + source.getAbsolutePath() + " : " + res));
        }
        if (!resources.isDirectory()) {
            res = resources.mkdirs();
            this.getLog().debug((CharSequence)("Creation of " + resources.getAbsolutePath() + " : " + res));
        }
        if (!test.isDirectory()) {
            res = test.mkdirs();
            this.getLog().debug((CharSequence)("Creation of " + test.getAbsolutePath() + " : " + res));
        }
    }

    private boolean isParentPom(Model model) {
        return "pom".equals(model.getPackaging());
    }

    private void addVertxDependencies(Model model) {
        if (model.getDependencies() != null) {
            if (!MojoUtils.hasDependency(this.project, "io.vertx", "vertx-core")) {
                model.getDependencies().add(MojoExecutor.dependency((String)"io.vertx", (String)"vertx-core", null));
            }
        } else {
            model.setDependencies(new ArrayList());
            model.getDependencies().add(MojoExecutor.dependency((String)"io.vertx", (String)"vertx-core", null));
        }
    }

    private void addVertxBom(Model model) {
        Dependency vertxBom = MojoExecutor.dependency((String)"io.vertx", (String)"vertx-dependencies", (String)"${vertx.projectVersion}");
        vertxBom.setType("pom");
        vertxBom.setScope("import");
        if (model.getDependencyManagement() != null) {
            if (!MojoUtils.hasDependency(this.project, "io.vertx", "vertx-dependencies")) {
                model.getDependencyManagement().addDependency(vertxBom);
            }
        } else {
            DependencyManagement depsMgmt = new DependencyManagement();
            depsMgmt.addDependency(vertxBom);
            model.setDependencyManagement(depsMgmt);
        }
    }
}

