/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.vertx.maven.plugin.utils;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ProjectDependencyGraph;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusContainer;

public class MavenExecutionUtils {
    public static void execute(String phase, MavenProject project, MavenSession session, LifecycleExecutor executor, PlexusContainer container) {
        MavenExecutionRequest request = MavenExecutionUtils.getMavenExecutionRequest(session, phase);
        MavenSession newSession = MavenExecutionUtils.getMavenSession(session, project, request, container);
        executor.execute(newSession);
    }

    private static MavenExecutionRequest getMavenExecutionRequest(MavenSession session, String phase) {
        MavenExecutionRequest request = DefaultMavenExecutionRequest.copy((MavenExecutionRequest)session.getRequest());
        request.setStartTime(session.getStartTime());
        request.setExecutionListener(null);
        request.setGoals((List)ImmutableList.of((Object)phase));
        return request;
    }

    private static MavenSession getMavenSession(MavenSession session, final MavenProject project, MavenExecutionRequest request, PlexusContainer container) {
        MavenSession newSession = new MavenSession(container, session.getRepositorySession(), request, session.getResult());
        newSession.setAllProjects(session.getAllProjects());
        newSession.setCurrentProject(project);
        newSession.setParallel(session.isParallel());
        LinkedHashMap<String, MavenProject> projectMaps = new LinkedHashMap<String, MavenProject>(session.getProjectMap());
        projectMaps.put(ArtifactUtils.key((String)project.getGroupId(), (String)project.getArtifactId(), (String)project.getVersion()), project);
        newSession.setProjectMap(projectMaps);
        ProjectDependencyGraph graph = new ProjectDependencyGraph(){

            public List<MavenProject> getSortedProjects() {
                return ImmutableList.of((Object)project);
            }

            public List<MavenProject> getDownstreamProjects(MavenProject project2, boolean transitive) {
                return Collections.emptyList();
            }

            public List<MavenProject> getUpstreamProjects(MavenProject project2, boolean transitive) {
                return Collections.emptyList();
            }
        };
        newSession.setProjectDependencyGraph(graph);
        newSession.setProjects((List)ImmutableList.of((Object)project));
        return newSession;
    }
}

