/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.vertx.maven.plugin.utils;

import io.fabric8.vertx.maven.plugin.mojos.AbstractVertxMojo;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.logging.Log;

public class WebJars {
    public static final Pattern WEBJAR_REGEX = Pattern.compile(".*META-INF/resources/webjars/([^/]+)/([^/]+)/.*");
    public static final String WEBJAR_LOCATION = "META-INF/resources/webjars/";
    public static final Pattern WEBJAR_INTERNAL_PATH_REGEX = Pattern.compile("([^/]+)/([^/]+)/(.*)");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isWebJar(Log log, File file) {
        if (file == null) {
            return false;
        }
        LinkedHashSet<String> found = new LinkedHashSet<String>();
        if (file.isFile() && file.getName().endsWith(".jar")) {
            JarFile jar = null;
            try {
                jar = new JarFile(file);
                if (jar.getEntry(WEBJAR_LOCATION) == null) {
                    boolean bl = false;
                    return bl;
                }
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    Matcher matcher = WEBJAR_REGEX.matcher(entry.getName());
                    if (!matcher.matches()) continue;
                    found.add(matcher.group(1) + "-" + matcher.group(2));
                }
            }
            catch (IOException e) {
                log.error((CharSequence)("Cannot check if the file " + file.getName() + " is a webjar, cannot open it"), (Throwable)e);
                boolean entry = false;
                return entry;
            }
            finally {
                JarFile finalJar = jar;
                IOUtils.closeQuietly(() -> {
                    if (finalJar != null) {
                        finalJar.close();
                    }
                });
            }
            for (String lib : found) {
                log.info((CharSequence)("Web Library found in " + file.getName() + " : " + lib));
            }
            return !found.isEmpty();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extract(AbstractVertxMojo mojo, File in, File out, boolean stripVersion) throws IOException {
        ZipFile file = new ZipFile(in);
        try {
            Enumeration<? extends ZipEntry> entries = file.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!entry.getName().startsWith(WEBJAR_LOCATION) || entry.isDirectory()) continue;
                File output = new File(out, entry.getName().substring(WEBJAR_LOCATION.length()));
                if (stripVersion) {
                    String path = entry.getName().substring(WEBJAR_LOCATION.length());
                    Matcher matcher = WEBJAR_INTERNAL_PATH_REGEX.matcher(path);
                    if (matcher.matches()) {
                        output = new File(out, matcher.group(1) + "/" + matcher.group(3));
                    } else {
                        mojo.getLog().warn((CharSequence)(path + " does not match the regex - did not strip the version for this file"));
                    }
                }
                InputStream stream = null;
                try {
                    stream = file.getInputStream(entry);
                    output.getParentFile().mkdirs();
                    FileUtils.copyInputStreamToFile((InputStream)stream, (File)output);
                }
                catch (IOException e) {
                    mojo.getLog().error((CharSequence)("Cannot unpack " + entry.getName() + " from " + file.getName()), (Throwable)e);
                    throw e;
                }
                finally {
                    IOUtils.closeQuietly((InputStream)stream);
                }
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)file);
        }
    }
}

