/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.volumesnapshot.client;

import io.fabric8.kubernetes.client.BaseClient;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.RequestConfig;
import io.fabric8.kubernetes.client.WithRequestCallable;
import io.fabric8.kubernetes.client.dsl.FunctionCallable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshot;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotClass;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotClassList;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotContent;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotContentList;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotList;
import io.fabric8.volumesnapshot.client.NamespacedVolumeSnapshotClient;
import io.fabric8.volumesnapshot.client.internal.VolumeSnapshotClassOperationsImpl;
import io.fabric8.volumesnapshot.client.internal.VolumeSnapshotClassResource;
import io.fabric8.volumesnapshot.client.internal.VolumeSnapshotContentOperationsImpl;
import io.fabric8.volumesnapshot.client.internal.VolumeSnapshotContentResource;
import io.fabric8.volumesnapshot.client.internal.VolumeSnapshotOperationsImpl;
import io.fabric8.volumesnapshot.client.internal.VolumeSnapshotResource;
import okhttp3.OkHttpClient;

public class DefaultVolumeSnapshotClient
extends BaseClient
implements NamespacedVolumeSnapshotClient {
    public DefaultVolumeSnapshotClient() {
    }

    public DefaultVolumeSnapshotClient(Config configuration) {
        super(configuration);
    }

    public DefaultVolumeSnapshotClient(OkHttpClient httpClient, Config configuration) {
        super(httpClient, configuration);
    }

    @Override
    public NonNamespaceOperation<VolumeSnapshotClass, VolumeSnapshotClassList, VolumeSnapshotClassResource> volumeSnapshotClasses() {
        return new VolumeSnapshotClassOperationsImpl(this.getHttpClient(), this.getConfiguration());
    }

    @Override
    public NonNamespaceOperation<VolumeSnapshotContent, VolumeSnapshotContentList, VolumeSnapshotContentResource> volumeSnapshotContents() {
        return new VolumeSnapshotContentOperationsImpl(this.getHttpClient(), this.getConfiguration());
    }

    @Override
    public MixedOperation<VolumeSnapshot, VolumeSnapshotList, VolumeSnapshotResource> volumeSnapshots() {
        return new VolumeSnapshotOperationsImpl(this.getHttpClient(), this.getConfiguration());
    }

    public NamespacedVolumeSnapshotClient inAnyNamespace() {
        return this.inNamespace(null);
    }

    public NamespacedVolumeSnapshotClient inNamespace(String namespace) {
        Config updated = ((ConfigBuilder)new ConfigBuilder(this.getConfiguration()).withNamespace(namespace)).build();
        return new DefaultVolumeSnapshotClient(this.getHttpClient(), updated);
    }

    public FunctionCallable<NamespacedVolumeSnapshotClient> withRequestConfig(RequestConfig requestConfig) {
        return new WithRequestCallable((Client)this, requestConfig);
    }
}

